/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.utils;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PixelArrayCache {
    private static final Logger LOG = Logger.getLogger(PixelArrayCache.class.getName());
    private static final int SMALL_THRESHOLD = 256;
    private static final int TILE_SIZE = 65536;
    private static ThreadLocal<CacheImpl> cache = new ThreadLocal<CacheImpl>(){

        @Override
        protected CacheImpl initialValue() {
            return new CacheImpl();
        }
    };

    private PixelArrayCache() {
    }

    public static int[] acquire(int size, boolean clear) {
        if (size > 256) {
            return cache.get().acquire(size, clear);
        }
        LOG.log(Level.FINEST, "Creating array below threshold of size : {0}", size);
        return new int[size];
    }

    public static void release(int[] array) {
        if (array.length > 256) {
            cache.get().release(array);
        }
    }

    private static class CacheImpl {
        private List<SoftReference<int[]>> arrays = new ArrayList<SoftReference<int[]>>();

        private CacheImpl() {
        }

        private int[] acquire(int size, boolean clear) {
            int[] array = null;
            SoftReference<int[]> ref = null;
            int minDiff = Integer.MAX_VALUE;
            Iterator<SoftReference<int[]>> itr = this.arrays.iterator();
            while (itr.hasNext()) {
                SoftReference<int[]> entry = itr.next();
                int[] ar = entry.get();
                if (ar == null) {
                    LOG.log(Level.FINEST, "Pixel array collected, removing SoftReference.\nList size : {0}", this.arrays.size());
                    itr.remove();
                    continue;
                }
                if (ar.length < size) continue;
                int diff = ar.length - size;
                if (array == null || diff < minDiff) {
                    array = ar;
                    ref = entry;
                    minDiff = diff;
                }
                if (diff != 0) continue;
                break;
            }
            if (array != null && minDiff < this.calculateSize(size)) {
                this.arrays.remove(ref);
                if (clear) {
                    Arrays.fill(array, 0);
                }
                return array;
            }
            array = new int[this.calculateSize(size)];
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Creating new array of size : " + array.length + "\n - Requested size : " + size + "\n - Cache list size : " + this.arrays.size() + "\n - Minimum Difference found : " + minDiff);
            }
            return array;
        }

        private int calculateSize(int minSize) {
            int size;
            for (size = 512; size < minSize; size *= 2) {
            }
            return size;
        }

        private void release(int[] array) {
            this.arrays.add(new SoftReference<int[]>(array));
        }
    }
}

