/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.admob.ParametersMatcher;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;
import org.prebid.mobile.rendering.bidding.display.BidResponseCache;
import org.prebid.mobile.rendering.bidding.display.DisplayView;
import org.prebid.mobile.rendering.bidding.listeners.DisplayViewListener;
import org.prebid.mobile.rendering.errors.AdException;
import org.prebid.mobile.rendering.models.AdConfiguration;

@Keep
public class PrebidBannerAdapter
extends PrebidBaseAdapter
implements CustomEventBanner {
    private static final String TAG = "PrebidBannerAdapter";
    public static final String EXTRA_RESPONSE_ID = "PrebidBannerAdapterExtraId";
    private DisplayView adView;

    /*
     * WARNING - void declaration
     */
    @NonNull
    private DisplayViewListener getListener(CustomEventBannerListener adMobListener) {
        void var1_1;
        return new DisplayViewListener((CustomEventBannerListener)var1_1){
            final /* synthetic */ CustomEventBannerListener a;
            {
                this.a = customEventBannerListener;
            }

            public void onAdLoaded() {
                this.a.onAdLoaded((View)PrebidBannerAdapter.this.adView);
            }

            public void onAdDisplayed() {
            }

            public void onAdFailed(AdException object) {
                if ((object = object.getMessage()) == null) {
                    object = "Failed to load DisplayView ad";
                }
                this.a.onAdFailedToLoad(new AdError(1010, (String)object, "prebid"));
            }

            public void onAdClicked() {
                a a2 = this;
                a2.a.onAdClicked();
                a2.a.onAdOpened();
            }

            public void onAdClosed() {
                this.a.onAdClosed();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void requestBannerAd(@NonNull Context context, @NonNull CustomEventBannerListener adMobListener, @Nullable String serverParameter, @NonNull AdSize adSize, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle extras) {
        void var1_1;
        AdConfiguration adConfiguration;
        BidResponse bidResponse;
        void var6_6;
        DisplayViewListener displayViewListener;
        Object object;
        if (extras == null) {
            AdError adError;
            Log.e((String)TAG, (String)"Extras are empty! Check if you add custom event extras bundle to  PrebidBannerAdapter");
            object = adError;
            adError = new AdError(1001, "Extras are empty! Check if you add custom event extras bundle to  PrebidBannerAdapter", "prebid");
            displayViewListener.onAdFailedToLoad((AdError)object);
            return;
        }
        String string = var6_6.getString(EXTRA_RESPONSE_ID);
        if (string == null) {
            AdError adError;
            object = adError;
            adError = new AdError(1002, "Response id is null", "prebid");
            displayViewListener.onAdFailedToLoad((AdError)object);
            return;
        }
        if (!ParametersMatcher.doParametersMatch((String)bidResponse, BidResponseCache.getInstance().getKeywords(string))) {
            AdError adError;
            object = adError;
            adError = new AdError(1003, "Parameters are different", "prebid");
            displayViewListener.onAdFailedToLoad((AdError)object);
            return;
        }
        LogUtil.v((String)TAG, (String)("Parameters are matched! (" + (String)bidResponse + ")"));
        bidResponse = BidResponseCache.getInstance().popBidResponse(string);
        if (bidResponse == null) {
            object = "There's no response for the response id: " + string;
            displayViewListener.onAdFailedToLoad(new AdError(1004, (String)object, "prebid"));
            return;
        }
        PrebidBannerAdapter prebidBannerAdapter = object;
        object = adConfiguration;
        new AdConfiguration().setAdUnitIdentifierType(AdConfiguration.AdUnitIdentifierType.BANNER);
        displayViewListener = prebidBannerAdapter.getListener((CustomEventBannerListener)displayViewListener);
        prebidBannerAdapter.adView = new DisplayView((Context)var1_1, displayViewListener, (AdConfiguration)object, bidResponse);
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
        PrebidBannerAdapter this_ = this_.adView;
        if (this_ != null) {
            this_.destroy();
        }
    }
}

