/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitial;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.admob.ParametersMatcher;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.rendering.bidding.display.BidResponseCache;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;
import org.prebid.mobile.rendering.errors.AdException;

public class PrebidInterstitialAdapter
extends PrebidBaseAdapter
implements CustomEventInterstitial {
    public static final String EXTRA_RESPONSE_ID = "PrebidInterstitialAdapterExtraId";
    private InterstitialController a;

    private InterstitialControllerListener a(final CustomEventInterstitialListener customEventInterstitialListener) {
        return new InterstitialControllerListener(this){

            public void onInterstitialReadyForDisplay() {
                customEventInterstitialListener.onAdLoaded();
            }

            public void onInterstitialDisplayed() {
                customEventInterstitialListener.onAdOpened();
            }

            public void onInterstitialClicked() {
                customEventInterstitialListener.onAdClicked();
            }

            public void onInterstitialClosed() {
                customEventInterstitialListener.onAdClosed();
            }

            public void onInterstitialFailedToLoad(AdException adException) {
                a a2 = string;
                String string = "Failed to load ad: " + adException.getMessage();
                Log.e((String)"PrebidInterstitial", (String)string);
                a2.customEventInterstitialListener.onAdFailedToLoad(new AdError(1005, string, "prebid"));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void requestInterstitialAd(@NonNull Context context, @NonNull CustomEventInterstitialListener adMobListener, @Nullable String serverParameter, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle extras) {
        InterstitialController interstitialController;
        InterstitialControllerListener interstitialControllerListener;
        InterstitialController interstitialController2;
        void var2_4;
        PrebidInterstitialAdapter prebidInterstitialAdapter;
        if (extras == null) {
            AdError adError;
            Log.e((String)"PrebidInterstitial", (String)"Extras are empty! Check if you add custom event extras bundle to  PrebidInterstitial");
            prebidInterstitialAdapter = adError;
            adError = new AdError(1001, "Extras are empty! Check if you add custom event extras bundle to  PrebidInterstitial", "prebid");
            var2_4.onAdFailedToLoad((AdError)prebidInterstitialAdapter);
            return;
        }
        String string = interstitialController2.getString(EXTRA_RESPONSE_ID);
        if (string == null) {
            AdError adError;
            prebidInterstitialAdapter = adError;
            adError = new AdError(1002, "Response id is null", "prebid");
            var2_4.onAdFailedToLoad((AdError)prebidInterstitialAdapter);
            return;
        }
        if (!ParametersMatcher.doParametersMatch((String)interstitialControllerListener, BidResponseCache.getInstance().getKeywords(string))) {
            AdError adError;
            prebidInterstitialAdapter = adError;
            adError = new AdError(1003, "Parameters are different", "prebid");
            var2_4.onAdFailedToLoad((AdError)prebidInterstitialAdapter);
            return;
        }
        LogUtil.v((String)"PrebidInterstitial", (String)("Parameters are matched! (" + (String)interstitialControllerListener + ")"));
        interstitialControllerListener = prebidInterstitialAdapter.a((CustomEventInterstitialListener)var2_4);
        interstitialController2 = interstitialController;
        try {
            void var1_3;
            InterstitialController interstitialController3 = interstitialController2;
            interstitialController3((Context)var1_3, interstitialControllerListener);
            prebidInterstitialAdapter.a = interstitialController3;
            interstitialController.loadAd(string, false);
        }
        catch (AdException adException) {
            String string2 = "Exception in Prebid interstitial controller (" + adException.getMessage() + ")";
            Log.e((String)"PrebidInterstitial", (String)string2);
            var2_4.onAdFailedToLoad(new AdError(1004, string2, "prebid"));
        }
    }

    public void showInterstitial() {
        this.a.show();
    }

    public void onDestroy() {
        this.a.destroy();
    }

    public void onPause() {
    }

    public void onResume() {
    }
}

