/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import java.util.HashMap;
import org.prebid.mobile.admob.ParametersMatcher;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.rendering.bidding.display.BidResponseCache;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;
import org.prebid.mobile.rendering.errors.AdException;

@Keep
public class PrebidRewardedAdapter
extends PrebidBaseAdapter {
    private static final String TAG = "PrebidRewardedAdapter";
    private static final String CLASS_NAME = "org.prebid.mobile.admob.PrebidRewardedAdapter";
    public static final String EXTRA_RESPONSE_ID = "PrebidRewardedAdapterExtraId";
    private InterstitialController interstitialController;
    private MediationRewardedAdCallback rewardedAdCallback;

    /*
     * WARNING - void declaration
     */
    private InterstitialControllerListener getListener(MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adMobCallback) {
        void var1_1;
        return new InterstitialControllerListener((MediationAdLoadCallback)var1_1){
            final /* synthetic */ MediationAdLoadCallback a;
            {
                this.a = mediationAdLoadCallback;
            }

            public void onInterstitialReadyForDisplay() {
                PrebidRewardedAdapter.access$002(PrebidRewardedAdapter.this, (MediationRewardedAdCallback)this.a.onSuccess(context -> PrebidRewardedAdapter.this.interstitialController.show()));
            }

            public void onInterstitialDisplayed() {
                a a2 = this;
                a2.PrebidRewardedAdapter.this.rewardedAdCallback.onAdOpened();
                a2.PrebidRewardedAdapter.this.rewardedAdCallback.onVideoStart();
                a2.PrebidRewardedAdapter.this.rewardedAdCallback.reportAdImpression();
            }

            public void onInterstitialClicked() {
                PrebidRewardedAdapter.this.rewardedAdCallback.reportAdClicked();
            }

            public void onInterstitialFailedToLoad(AdException object) {
                AdError adError;
                object = object.getMessage() != null ? object.getMessage() : "Failed to load ad";
                a a2 = this;
                AdError adError2 = adError;
                adError = new AdError(1006, (String)object, "prebid");
                a2.a.onFailure(adError2);
                if (a2.PrebidRewardedAdapter.this.rewardedAdCallback != null) {
                    PrebidRewardedAdapter.this.rewardedAdCallback.onAdFailedToShow(adError2);
                }
            }

            public void onInterstitialClosed() {
                a a2 = this;
                a2.PrebidRewardedAdapter.this.rewardedAdCallback.onVideoComplete();
                a2.PrebidRewardedAdapter.this.rewardedAdCallback.onAdClosed();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MediationRewardedAdCallback access$002(PrebidRewardedAdapter x0, MediationRewardedAdCallback x1) {
        void var1_1;
        var0.rewardedAdCallback = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        InterstitialController interstitialController;
        void var1_3;
        void var2_4;
        PrebidRewardedAdapter prebidRewardedAdapter;
        Bundle bundle = adConfiguration.getServerParameters();
        String string = bundle.getString("parameter");
        if (!bundle.getString("class_name").equals(CLASS_NAME)) {
            AdError adError;
            prebidRewardedAdapter = adError;
            adError = new AdError(1001, "Class name is different", "prebid");
            var2_4.onFailure((AdError)prebidRewardedAdapter);
            return;
        }
        String string2 = var1_3.getMediationExtras().getString(EXTRA_RESPONSE_ID);
        if (string2 == null) {
            AdError adError;
            prebidRewardedAdapter = adError;
            adError = new AdError(1002, "Empty response id", "prebid");
            var2_4.onFailure((AdError)prebidRewardedAdapter);
            return;
        }
        HashMap hashMap = BidResponseCache.getInstance().getKeywords(string2);
        if (hashMap == null) {
            AdError adError;
            prebidRewardedAdapter = adError;
            adError = new AdError(1003, "Prebid keywords are empty", "prebid");
            var2_4.onFailure((AdError)prebidRewardedAdapter);
            return;
        }
        if (!ParametersMatcher.doParametersMatch(string, hashMap)) {
            AdError adError;
            prebidRewardedAdapter = adError;
            adError = new AdError(1004, "Parameters are different", "prebid");
            var2_4.onFailure((AdError)prebidRewardedAdapter);
            return;
        }
        string = prebidRewardedAdapter.getListener((MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback>)var2_4);
        hashMap = interstitialController;
        try {
            HashMap hashMap2 = hashMap;
            hashMap2(var1_3.getContext(), (InterstitialControllerListener)string);
            prebidRewardedAdapter.interstitialController = hashMap2;
            interstitialController.loadAd(string2, true);
        }
        catch (AdException adException) {
            String string3 = "Exception in Prebid interstitial controller (" + adException.getMessage() + ")";
            Log.e((String)TAG, (String)string3);
            var2_4.onFailure(new AdError(1005, string3, "prebid"));
        }
    }
}

