/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import java.util.HashMap;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.ParametersMatcher;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.api.data.AdFormat;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.api.rendering.DisplayView;
import org.prebid.mobile.configuration.AdUnitConfiguration;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;
import org.prebid.mobile.rendering.bidding.display.BidResponseCache;
import org.prebid.mobile.rendering.bidding.listeners.DisplayViewListener;

@Keep
public class PrebidBannerAdapter
extends PrebidBaseAdapter
implements CustomEventBanner {
    private static final String TAG = "PrebidBannerAdapter";
    public static final String EXTRA_RESPONSE_ID = "PrebidBannerAdapterExtraId";
    private DisplayView adView;

    public void requestBannerAd(@NonNull Context context, @NonNull CustomEventBannerListener adMobListener, @Nullable String serverParameter, @NonNull AdSize adSize, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle extras) {
        if (extras == null) {
            String error = "Extras are empty! Check if you add custom event extras bundle to  PrebidBannerAdapter";
            Log.e((String)TAG, (String)error);
            adMobListener.onAdFailedToLoad(new AdError(1001, error, "prebid"));
            return;
        }
        String responseId = extras.getString(EXTRA_RESPONSE_ID);
        if (responseId == null) {
            String error = "Response id is null";
            adMobListener.onAdFailedToLoad(new AdError(1002, error, "prebid"));
            return;
        }
        HashMap prebidParameters = BidResponseCache.getInstance().getKeywords(responseId);
        if (!ParametersMatcher.doParametersMatch((String)serverParameter, (HashMap)prebidParameters)) {
            String error = "Parameters are different";
            adMobListener.onAdFailedToLoad(new AdError(1003, error, "prebid"));
            return;
        }
        LogUtil.verbose((String)TAG, (String)("Parameters are matched! (" + serverParameter + ")"));
        BidResponse response = BidResponseCache.getInstance().popBidResponse(responseId);
        if (response == null) {
            String error = "There's no response for the response id: " + responseId;
            adMobListener.onAdFailedToLoad(new AdError(1004, error, "prebid"));
            return;
        }
        AdUnitConfiguration adConfiguration = new AdUnitConfiguration();
        adConfiguration.setAdFormat(AdFormat.BANNER);
        DisplayViewListener listener = this.getListener(adMobListener);
        this.adView = new DisplayView(context, listener, adConfiguration, response);
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
        }
    }

    @NonNull
    private DisplayViewListener getListener(final CustomEventBannerListener adMobListener) {
        return new DisplayViewListener(){

            public void onAdLoaded() {
                adMobListener.onAdLoaded((View)PrebidBannerAdapter.this.adView);
            }

            public void onAdDisplayed() {
            }

            public void onAdFailed(AdException exception) {
                String message = exception.getMessage();
                if (message == null) {
                    message = "Failed to load DisplayView ad";
                }
                adMobListener.onAdFailedToLoad(new AdError(1010, message, "prebid"));
            }

            public void onAdClicked() {
                adMobListener.onAdClicked();
                adMobListener.onAdOpened();
            }

            public void onAdClosed() {
                adMobListener.onAdClosed();
            }
        };
    }
}

