/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import java.util.ArrayList;
import java.util.Map;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.PrebidNativeAdEventListener;

public class PrebidNativeAdMapper
extends UnifiedNativeAdMapper {
    private final PrebidNativeAd prebidAd;
    private final PrebidNativeAdEventListener prebidListener = this.createListener();
    private final CustomEventNativeListener adMobListener;

    public PrebidNativeAdMapper(PrebidNativeAd prebidAd, CustomEventNativeListener adMobListener) {
        this.prebidAd = prebidAd;
        this.adMobListener = adMobListener;
    }

    public void trackViews(@NonNull View view, @NonNull Map<String, View> map, @NonNull Map<String, View> map1) {
        super.trackViews(view, map, map1);
        this.prebidAd.registerViewList(view, new ArrayList<View>(map.values()), this.createListener());
    }

    public void recordImpression() {
        this.prebidListener.onAdImpression();
    }

    public void handleClick(@NonNull View view) {
        this.prebidListener.onAdClicked();
    }

    private PrebidNativeAdEventListener createListener() {
        return new PrebidNativeAdEventListener(){

            public void onAdClicked() {
                PrebidNativeAdMapper.this.adMobListener.onAdClicked();
                PrebidNativeAdMapper.this.adMobListener.onAdOpened();
            }

            public void onAdImpression() {
            }

            public void onAdExpired() {
            }
        };
    }
}

