/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.customevent.CustomEventNative;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.ParametersMatcher;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.admob.PrebidNativeAdMapper;
import org.prebid.mobile.rendering.bidding.events.EventsNotifier;

public class PrebidNativeAdapter
extends PrebidBaseAdapter
implements CustomEventNative {
    private static final String TAG = "PrebidNative";

    public void requestNativeAd(@NonNull Context context, @NonNull CustomEventNativeListener adMobListener, @Nullable String serverParameter, @NonNull NativeMediationAdRequest mediationAdRequest, @Nullable Bundle extras) {
        if (extras == null) {
            String error = "Extras are empty! Check if you add custom event extras bundle to  PrebidNative";
            Log.e((String)TAG, (String)error);
            adMobListener.onAdFailedToLoad(new AdError(1001, error, "prebid"));
            return;
        }
        String cacheId = extras.getString("NativeAdUnitCacheId");
        if (cacheId == null) {
            String error = "Cache id is null";
            adMobListener.onAdFailedToLoad(new AdError(1002, error, "prebid"));
            return;
        }
        Bundle extrasCopy = new Bundle(extras);
        extrasCopy.remove("NativeAdUnitCacheId");
        HashMap<String, String> prebidParameters = this.convertToMap(extrasCopy);
        if (!ParametersMatcher.doParametersMatch((String)serverParameter, prebidParameters)) {
            String error = "Parameters are different";
            adMobListener.onAdFailedToLoad(new AdError(1003, error, "prebid"));
            return;
        }
        LogUtil.verbose((String)TAG, (String)("Parameters are matched! (" + serverParameter + ")"));
        PrebidNativeAd nativeAd = PrebidNativeAd.create((String)cacheId);
        if (nativeAd == null) {
            String error = "PrebidNativeAd is null";
            adMobListener.onAdFailedToLoad(new AdError(1004, error, "prebid"));
            return;
        }
        EventsNotifier.notify((String)nativeAd.getWinEvent());
        PrebidNativeAdMapper mapper = new PrebidNativeAdMapper(nativeAd, adMobListener);
        this.configureMapper(mapper, nativeAd, context);
        adMobListener.onAdLoaded((UnifiedNativeAdMapper)mapper);
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    private HashMap<String, String> convertToMap(Bundle bundle) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set keySet = bundle.keySet();
        for (String key : keySet) {
            String value = bundle.getString(key);
            result.put(key, value);
        }
        return result;
    }

    private void configureMapper(PrebidNativeAdMapper mapper, PrebidNativeAd prebidAd, Context context) {
        ArrayList<PrebidImage> images = new ArrayList<PrebidImage>();
        images.add(new PrebidImage(prebidAd.getImageUrl(), context));
        mapper.setImages(images);
        mapper.setHeadline(prebidAd.getTitle());
        mapper.setBody(prebidAd.getDescription());
        mapper.setCallToAction(prebidAd.getCallToAction());
        mapper.setIcon(new PrebidImage(prebidAd.getIconUrl(), context));
        mapper.setAdvertiser(prebidAd.getSponsoredBy());
        mapper.setOverrideClickHandling(true);
        mapper.setOverrideImpressionRecording(false);
    }

    private static class PrebidImage
    extends NativeAd.Image {
        private final String url;
        private final double scale;
        private Drawable downloadedImage = null;

        public PrebidImage(String url, Context context) {
            this.url = url;
            this.scale = context.getResources().getDisplayMetrics().density;
        }

        @Nullable
        public Drawable getDrawable() {
            if (this.downloadedImage != null) {
                return this.downloadedImage;
            }
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
                connection.connect();
                InputStream input = connection.getInputStream();
                Bitmap x = BitmapFactory.decodeStream((InputStream)input);
                this.downloadedImage = new BitmapDrawable(Resources.getSystem(), x);
                return this.downloadedImage;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Nullable
        public Uri getUri() {
            return Uri.parse((String)this.url);
        }

        public double getScale() {
            return this.scale;
        }
    }
}

