/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import org.prebid.mobile.admob.AdErrors;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.api.data.AdFormat;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.api.rendering.DisplayView;
import org.prebid.mobile.configuration.AdUnitConfiguration;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;
import org.prebid.mobile.rendering.bidding.display.BidResponseCache;
import org.prebid.mobile.rendering.bidding.listeners.DisplayViewListener;

public class PrebidBannerAdapter
extends PrebidBaseAdapter {
    public static final String EXTRA_RESPONSE_ID = "PrebidBannerAdapterExtraId";
    private DisplayView adView;
    @Nullable
    private MediationBannerAdCallback adMobBannerListener;

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration configuration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> adMobLoadListener) {
        String responseId = this.getResponseIdAndCheckParameters((MediationAdConfiguration)configuration, EXTRA_RESPONSE_ID, arg_0 -> adMobLoadListener.onFailure(arg_0));
        if (responseId == null) {
            return;
        }
        BidResponse response = BidResponseCache.getInstance().popBidResponse(responseId);
        if (response == null) {
            adMobLoadListener.onFailure(AdErrors.noResponse(responseId));
            return;
        }
        AdUnitConfiguration adConfiguration = new AdUnitConfiguration();
        adConfiguration.setAdFormat(AdFormat.BANNER);
        DisplayViewListener listener = this.getPrebidListener(adMobLoadListener);
        this.adView = new DisplayView(configuration.getContext(), listener, adConfiguration, response);
    }

    @NonNull
    private DisplayViewListener getPrebidListener(final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> adMobLoadListener) {
        return new DisplayViewListener(){

            public void onAdLoaded() {
                PrebidBannerAdapter.this.adMobBannerListener = (MediationBannerAdCallback)adMobLoadListener.onSuccess(() -> PrebidBannerAdapter.this.adView);
            }

            public void onAdDisplayed() {
                if (PrebidBannerAdapter.this.adMobBannerListener != null) {
                    PrebidBannerAdapter.this.adMobBannerListener.reportAdImpression();
                }
            }

            public void onAdClicked() {
                if (PrebidBannerAdapter.this.adMobBannerListener != null) {
                    PrebidBannerAdapter.this.adMobBannerListener.onAdOpened();
                    PrebidBannerAdapter.this.adMobBannerListener.reportAdClicked();
                }
            }

            public void onAdClosed() {
                if (PrebidBannerAdapter.this.adMobBannerListener != null) {
                    PrebidBannerAdapter.this.adMobBannerListener.onAdClosed();
                }
            }

            public void onAdFailed(AdException exception) {
                adMobLoadListener.onFailure(AdErrors.failedToLoadAd(exception.getMessage()));
            }
        };
    }
}

