/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.PrebidNativeAdEventListener;

public class PrebidNativeAdMapper
extends UnifiedNativeAdMapper {
    private final PrebidNativeAd prebidAd;
    @Nullable
    private PrebidNativeAdEventListener prebidListener;

    public PrebidNativeAdMapper(PrebidNativeAd prebidAd) {
        this.prebidAd = prebidAd;
    }

    public void trackViews(@NonNull View view, @NonNull Map<String, View> map, @NonNull Map<String, View> map1) {
        super.trackViews(view, map, map1);
        this.prebidAd.registerView(view, new ArrayList<View>(map.values()), this.prebidListener);
    }

    public void recordImpression() {
        if (this.prebidListener != null) {
            this.prebidListener.onAdImpression();
        }
    }

    public void handleClick(@NonNull View view) {
        if (this.prebidListener != null) {
            this.prebidListener.onAdClicked();
        }
    }

    public void configure(MediationNativeAdConfiguration configuration, MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> adMobLoadListener) {
        ArrayList<PrebidImage> images = new ArrayList<PrebidImage>();
        images.add(new PrebidImage(this.prebidAd.getImageUrl(), configuration.getContext()));
        this.setImages(images);
        this.setHeadline(this.prebidAd.getTitle());
        this.setBody(this.prebidAd.getDescription());
        this.setCallToAction(this.prebidAd.getCallToAction());
        this.setIcon(new PrebidImage(this.prebidAd.getIconUrl(), configuration.getContext()));
        this.setAdvertiser(this.prebidAd.getSponsoredBy());
        this.setOverrideClickHandling(true);
        this.setOverrideImpressionRecording(false);
        MediationNativeAdCallback adMobListener = (MediationNativeAdCallback)adMobLoadListener.onSuccess((Object)this);
        this.prebidListener = new SafeNativeListener(adMobListener);
    }

    private static class PrebidImage
    extends NativeAd.Image {
        private final String url;
        private final double scale;
        private Drawable downloadedImage = null;

        public PrebidImage(String url, Context context) {
            this.url = url;
            this.scale = context.getResources().getDisplayMetrics().density;
        }

        @NonNull
        public Drawable getDrawable() {
            if (this.downloadedImage != null) {
                return this.downloadedImage;
            }
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
                connection.connect();
                InputStream input = connection.getInputStream();
                Bitmap x = BitmapFactory.decodeStream((InputStream)input);
                this.downloadedImage = new BitmapDrawable(Resources.getSystem(), x);
                return this.downloadedImage;
            }
            catch (Exception exception) {
                return new ShapeDrawable((Shape)new RectShape());
            }
        }

        @NonNull
        public Uri getUri() {
            return Uri.parse((String)this.url);
        }

        public double getScale() {
            return this.scale;
        }
    }

    private static class SafeNativeListener
    implements PrebidNativeAdEventListener {
        private final WeakReference<MediationNativeAdCallback> listenerReference;

        public SafeNativeListener(MediationNativeAdCallback adMobNativeListener) {
            this.listenerReference = new WeakReference<MediationNativeAdCallback>(adMobNativeListener);
        }

        public void onAdClicked() {
            MediationNativeAdCallback listener = (MediationNativeAdCallback)this.listenerReference.get();
            if (listener != null) {
                listener.reportAdClicked();
                listener.onAdOpened();
            }
        }

        public void onAdImpression() {
            MediationNativeAdCallback listener = (MediationNativeAdCallback)this.listenerReference.get();
            if (listener != null) {
                Runnable reportImpression = () -> ((MediationNativeAdCallback)listener).reportAdImpression();
                new Handler(Looper.getMainLooper()).post(reportImpression);
            }
        }

        public void onAdExpired() {
        }
    }
}

