/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import java.util.HashMap;
import java.util.Set;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.ParametersMatcher;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.admob.AdErrors;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.admob.PrebidNativeAdMapper;
import org.prebid.mobile.rendering.bidding.events.EventsNotifier;

public class PrebidNativeAdapter
extends PrebidBaseAdapter {
    private static final String TAG = "PrebidNative";

    public void loadNativeAd(@NonNull MediationNativeAdConfiguration configuration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> adMobLoadListener) {
        Bundle extras = configuration.getMediationExtras();
        String cacheId = extras.getString("NativeAdUnitCacheId");
        if (cacheId == null) {
            adMobLoadListener.onFailure(AdErrors.emptyNativeCacheId());
            return;
        }
        Bundle extrasCopy = new Bundle(extras);
        extrasCopy.remove("NativeAdUnitCacheId");
        HashMap<String, String> prebidParameters = this.convertToMap(extrasCopy);
        String serverParameter = configuration.getServerParameters().getString("parameter");
        if (!ParametersMatcher.doParametersMatch((String)serverParameter, prebidParameters)) {
            adMobLoadListener.onFailure(AdErrors.notMatchedParameters());
            return;
        }
        LogUtil.verbose((String)TAG, (String)("Parameters are matched! (" + serverParameter + ")"));
        PrebidNativeAd nativeAd = PrebidNativeAd.create((String)cacheId);
        if (nativeAd == null) {
            adMobLoadListener.onFailure(AdErrors.prebidNativeAdIsNull());
            return;
        }
        EventsNotifier.notify((String)nativeAd.getWinEvent());
        PrebidNativeAdMapper mapper = new PrebidNativeAdMapper(nativeAd);
        mapper.configure(configuration, adMobLoadListener);
    }

    private HashMap<String, String> convertToMap(Bundle bundle) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set keySet = bundle.keySet();
        for (String key : keySet) {
            String value = bundle.getString(key);
            result.put(key, value);
        }
        return result;
    }
}

