/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.admob;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import org.prebid.mobile.admob.AdErrors;
import org.prebid.mobile.admob.PrebidBaseAdapter;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;

@Keep
public class PrebidRewardedAdapter
extends PrebidBaseAdapter {
    public static final String EXTRA_RESPONSE_ID = "PrebidRewardedAdapterExtraId";
    @Nullable
    private InterstitialController interstitialController;
    @Nullable
    private MediationRewardedAdCallback rewardedAdCallback;

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration configuration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adMobLoadListener) {
        String responseId = this.getResponseIdAndCheckParameters((MediationAdConfiguration)configuration, EXTRA_RESPONSE_ID, arg_0 -> adMobLoadListener.onFailure(arg_0));
        if (responseId == null) {
            return;
        }
        try {
            InterstitialControllerListener prebidListener = this.getListener(adMobLoadListener);
            this.interstitialController = new InterstitialController(configuration.getContext(), prebidListener);
            this.interstitialController.setRewardListener(() -> ((InterstitialControllerListener)prebidListener).onUserEarnedReward());
            this.interstitialController.loadAd(responseId, true);
        }
        catch (AdException e) {
            adMobLoadListener.onFailure(AdErrors.interstitialControllerError(e.getMessage()));
        }
    }

    private InterstitialControllerListener getListener(final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adMobCallback) {
        return new InterstitialControllerListener(){

            public void onInterstitialReadyForDisplay() {
                PrebidRewardedAdapter.this.rewardedAdCallback = (MediationRewardedAdCallback)adMobCallback.onSuccess(context -> {
                    if (PrebidRewardedAdapter.this.interstitialController != null) {
                        PrebidRewardedAdapter.this.interstitialController.show();
                    }
                });
            }

            public void onInterstitialDisplayed() {
                if (PrebidRewardedAdapter.this.rewardedAdCallback != null) {
                    PrebidRewardedAdapter.this.rewardedAdCallback.reportAdImpression();
                    PrebidRewardedAdapter.this.rewardedAdCallback.onAdOpened();
                    PrebidRewardedAdapter.this.rewardedAdCallback.onVideoStart();
                }
            }

            public void onInterstitialClicked() {
                if (PrebidRewardedAdapter.this.rewardedAdCallback != null) {
                    PrebidRewardedAdapter.this.rewardedAdCallback.reportAdClicked();
                }
            }

            public void onInterstitialClosed() {
                if (PrebidRewardedAdapter.this.rewardedAdCallback != null) {
                    PrebidRewardedAdapter.this.rewardedAdCallback.onVideoComplete();
                    PrebidRewardedAdapter.this.rewardedAdCallback.onAdClosed();
                }
            }

            public void onInterstitialFailedToLoad(AdException exception) {
                adMobCallback.onFailure(AdErrors.failedToLoadAd(exception.getMessage() != null ? exception.getMessage() : "Failed to load ad"));
            }

            public void onUserEarnedReward() {
                if (PrebidRewardedAdapter.this.rewardedAdCallback != null && PrebidRewardedAdapter.this.interstitialController != null) {
                    PrebidRewardedAdapter.this.rewardedAdCallback.onUserEarnedReward();
                }
            }
        };
    }
}

