/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters.prebid;

import com.applovin.impl.mediation.MaxRewardImpl;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;
import org.prebid.mobile.rendering.bidding.listeners.DisplayViewListener;

public class ListenersCreator {
    public static DisplayViewListener createBannerListener(final MaxAdViewAdapterListener maxListener, final OnBannerAdViewLoaded listener) {
        return new DisplayViewListener(){

            public void onAdLoaded() {
                listener.run();
            }

            public void onAdDisplayed() {
                maxListener.onAdViewAdDisplayed();
            }

            public void onAdFailed(AdException exception) {
                maxListener.onAdViewAdDisplayFailed(new MaxAdapterError(2001, "Ad failed: " + exception.getMessage()));
            }

            public void onAdClicked() {
                maxListener.onAdViewAdClicked();
                maxListener.onAdViewAdExpanded();
            }

            public void onAdClosed() {
                maxListener.onAdViewAdCollapsed();
                maxListener.onAdViewAdHidden();
            }
        };
    }

    public static InterstitialControllerListener createInterstitialListener(final MaxInterstitialAdapterListener maxListener) {
        return new InterstitialControllerListener(){

            public void onInterstitialReadyForDisplay() {
                maxListener.onInterstitialAdLoaded();
            }

            public void onInterstitialClicked() {
                maxListener.onInterstitialAdClicked();
            }

            public void onInterstitialFailedToLoad(AdException exception) {
                maxListener.onInterstitialAdLoadFailed(new MaxAdapterError(2002, "Ad failed: " + exception.getMessage()));
            }

            public void onInterstitialDisplayed() {
                maxListener.onInterstitialAdDisplayed();
            }

            public void onInterstitialClosed() {
                maxListener.onInterstitialAdHidden();
            }
        };
    }

    public static InterstitialControllerListener createRewardedListener(final MaxRewardedAdapterListener maxListener) {
        return new InterstitialControllerListener(){

            public void onInterstitialReadyForDisplay() {
                maxListener.onRewardedAdLoaded();
            }

            public void onInterstitialClicked() {
                maxListener.onRewardedAdClicked();
            }

            public void onInterstitialFailedToLoad(AdException exception) {
                maxListener.onRewardedAdLoadFailed(new MaxAdapterError(2002, "Ad failed: " + exception.getMessage()));
            }

            public void onInterstitialDisplayed() {
                maxListener.onRewardedAdDisplayed();
                maxListener.onRewardedAdVideoStarted();
            }

            public void onInterstitialClosed() {
                maxListener.onRewardedAdVideoCompleted();
                maxListener.onRewardedAdHidden();
                maxListener.onUserRewarded(MaxRewardImpl.createDefault());
            }
        };
    }

    public static interface OnBannerAdViewLoaded {
        public void run();
    }
}

