/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters.prebid.managers;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.prebid.ParametersChecker;
import com.applovin.mediation.adapters.prebid.PrebidMaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.rendering.bidding.events.EventsNotifier;

public class MaxNativeManager {
    private static final String TAG = MaxNativeManager.class.getSimpleName();
    private MaxNativeAdAdapterListener maxListener;
    private HttpURLConnection connection;
    private InputStream inputStream;

    public void loadAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener maxListener) {
        this.maxListener = maxListener;
        PrebidNativeAd prebidNativeAd = ParametersChecker.getNativeAd(parameters, this::onError);
        if (prebidNativeAd == null) {
            return;
        }
        EventsNotifier.notify((String)prebidNativeAd.getWinEvent());
        MaxNativeAd maxNativeAd = this.createMaxNativeAd(prebidNativeAd, activity, maxListener);
        maxListener.onNativeAdLoaded(maxNativeAd, new Bundle());
    }

    public void destroy() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MaxNativeAd createMaxNativeAd(PrebidNativeAd ad, Activity activity, MaxNativeAdAdapterListener maxListener) {
        Bitmap iconBitmap;
        MaxNativeAd.Builder builder = new MaxNativeAd.Builder();
        builder.setTitle(ad.getTitle()).setAdvertiser(ad.getSponsoredBy()).setBody(ad.getDescription()).setCallToAction(ad.getCallToAction());
        Bitmap mainBitmap = this.downloadImage(ad.getImageUrl());
        if (mainBitmap != null) {
            ImageView imageView = new ImageView((Context)activity);
            imageView.setImageBitmap(mainBitmap);
            builder.setMediaView((View)imageView);
        }
        if ((iconBitmap = this.downloadImage(ad.getIconUrl())) != null) {
            BitmapDrawable drawable = new BitmapDrawable(activity.getResources(), iconBitmap);
            builder.setIcon(new MaxNativeAd.MaxNativeAdImage((Drawable)drawable));
        }
        return new PrebidMaxNativeAd(builder, ad, maxListener);
    }

    @Nullable
    private Bitmap downloadImage(String url) {
        Bitmap result = null;
        try {
            URL mainImageUrl = new URL(url);
            this.connection = (HttpURLConnection)mainImageUrl.openConnection();
            this.connection.connect();
            this.inputStream = this.connection.getInputStream();
            result = BitmapFactory.decodeStream((InputStream)this.inputStream);
            this.inputStream.close();
            this.connection.disconnect();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Can't download image: (" + url + ")"));
        }
        return result;
    }

    private void onError(int code, String error) {
        if (this.maxListener != null) {
            this.maxListener.onNativeAdLoadFailed(new MaxAdapterError(code, error));
        } else {
            Log.e((String)TAG, (String)"Max interstitial listener must be not null!");
        }
    }
}

