/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters.prebid.utils;

import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;
import com.applovin.mediation.adapters.PrebidMaxMediationAdapter;
import com.applovin.mediation.ads.MaxAdView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;
import org.prebid.mobile.rendering.bidding.display.PrebidMediationDelegate;
import org.prebid.mobile.rendering.models.internal.VisibilityTrackerOption;
import org.prebid.mobile.rendering.models.ntv.NativeEventTracker;
import org.prebid.mobile.rendering.utils.helpers.VisibilityChecker;

public class MaxMediationBannerUtils
implements PrebidMediationDelegate {
    private static final String TAG = MaxMediationBannerUtils.class.getSimpleName();
    private final WeakReference<MaxAdView> adViewReference;

    public MaxMediationBannerUtils(MaxAdView adView) {
        this.adViewReference = new WeakReference<MaxAdView>(adView);
    }

    public void setResponseToLocalExtras(@Nullable BidResponse response) {
        if (this.adViewReference.get() != null) {
            String responseId = response != null ? response.getId() : null;
            ((MaxAdView)this.adViewReference.get()).setLocalExtraParameter(PrebidMaxMediationAdapter.EXTRA_RESPONSE_ID, (Object)responseId);
        }
    }

    public boolean canPerformRefresh() {
        MaxAdView view = (MaxAdView)this.adViewReference.get();
        if (view == null) {
            LogUtil.error((String)TAG, (String)"AdView is null, it can be destroyed as WeakReference");
            return false;
        }
        VisibilityTrackerOption visibilityTrackerOption = new VisibilityTrackerOption(NativeEventTracker.EventType.IMPRESSION);
        VisibilityChecker checker = new VisibilityChecker(visibilityTrackerOption);
        boolean isVisible = checker.isVisibleForRefresh((View)view);
        if (isVisible) {
            Log.d((String)TAG, (String)"Visibility checker result: true");
        } else {
            Log.e((String)TAG, (String)"Can't perform refresh. Ad view is not visible.");
        }
        return true;
    }

    public void handleKeywordsUpdate(@Nullable HashMap<String, String> keywords) {
    }
}

