/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.prebid.managers.MaxBannerManager;
import com.applovin.mediation.adapters.prebid.managers.MaxInterstitialManager;
import com.applovin.mediation.adapters.prebid.managers.MaxNativeManager;
import com.applovin.mediation.adapters.prebid.managers.MaxRewardedManager;
import com.applovin.sdk.AppLovinSdk;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.TargetingParams;
import org.prebid.mobile.api.data.InitializationStatus;

public class PrebidMaxMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxNativeAdAdapter {
    public static final String TAG = PrebidMaxMediationAdapter.class.getSimpleName();
    public static final String EXTRA_RESPONSE_ID = TAG + "ExtraResponseId";
    public static final String EXTRA_KEYWORDS_ID = TAG + "ExtraKeywordsId";
    private MaxBannerManager maxBannerManager;
    private MaxInterstitialManager maxInterstitialManager;
    private MaxRewardedManager maxRewardedManager;
    private MaxNativeManager maxNativeManager;

    public PrebidMaxMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.setConsents(parameters);
        if (PrebidMobile.isSdkInitialized()) {
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            Runnable runnable = () -> {
                if (activity == null) {
                    return;
                }
                PrebidMobile.initializeSdk((Context)activity.getApplicationContext(), status -> {
                    if (onCompletionListener != null) {
                        if (status != InitializationStatus.FAILED) {
                            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
                        } else {
                            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, status.getDescription());
                        }
                    }
                });
            };
            handler.post(runnable);
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZING, null);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener listener) {
        this.maxBannerManager = new MaxBannerManager();
        this.maxBannerManager.loadAd(parameters, maxAdFormat, activity, listener);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener maxListener) {
        this.maxInterstitialManager = new MaxInterstitialManager();
        this.maxInterstitialManager.loadAd(parameters, activity, maxListener);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener maxListener) {
        this.maxRewardedManager = new MaxRewardedManager();
        this.maxRewardedManager.loadAd(parameters, activity, maxListener);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener maxListener) {
        this.maxInterstitialManager.showAd();
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener maxListener) {
        this.maxRewardedManager.showAd();
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener maxListener) {
        this.maxNativeManager = new MaxNativeManager();
        this.maxNativeManager.loadAd(parameters, activity, maxListener);
    }

    public void onDestroy() {
        if (this.maxBannerManager != null) {
            this.maxBannerManager.destroy();
        }
        if (this.maxInterstitialManager != null) {
            this.maxInterstitialManager.destroy();
        }
        if (this.maxRewardedManager != null) {
            this.maxRewardedManager.destroy();
        }
        if (this.maxNativeManager != null) {
            this.maxNativeManager.destroy();
        }
    }

    public String getAdapterVersion() {
        return "2.3.1";
    }

    public String getSdkVersion() {
        return "2.3.1";
    }

    private void setConsents(MaxAdapterInitializationParameters parameters) {
        Boolean ageRestrictedUser;
        if (parameters != null && (ageRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
            TargetingParams.setSubjectToCOPPA((Boolean)ageRestrictedUser);
        }
    }
}

