/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters.prebid;

import android.os.Bundle;
import android.view.View;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import org.prebid.mobile.PrebidNativeAd;
import org.prebid.mobile.PrebidNativeAdEventListener;

public class PrebidMaxNativeAd
extends MaxNativeAd {
    private final PrebidNativeAd prebidNativeAd;
    private final MaxNativeAdAdapterListener maxListener;

    public PrebidMaxNativeAd(MaxNativeAd.Builder builder, PrebidNativeAd prebidNativeAd, MaxNativeAdAdapterListener maxListener) {
        super(builder);
        this.prebidNativeAd = prebidNativeAd;
        this.maxListener = maxListener;
    }

    public void prepareViewForInteraction(MaxNativeAdView maxView) {
        super.prepareViewForInteraction(maxView);
        ArrayList<View> views = new ArrayList<View>(7);
        views.addAll(Arrays.asList(maxView.getAdvertiserTextView(), maxView.getBodyTextView(), maxView.getTitleTextView(), maxView.getMainView(), maxView.getIconImageView(), maxView.getCallToActionButton(), maxView.getMediaContentViewGroup()));
        this.prebidNativeAd.registerView((View)maxView, views, (PrebidNativeAdEventListener)new SafeNativeListener(this.maxListener));
    }

    private static class SafeNativeListener
    implements PrebidNativeAdEventListener {
        private final WeakReference<MaxNativeAdAdapterListener> listenerReference;

        public SafeNativeListener(MaxNativeAdAdapterListener maxListener) {
            this.listenerReference = new WeakReference<MaxNativeAdAdapterListener>(maxListener);
        }

        public void onAdClicked() {
            MaxNativeAdAdapterListener listener = (MaxNativeAdAdapterListener)this.listenerReference.get();
            if (listener != null) {
                listener.onNativeAdClicked();
            }
        }

        public void onAdImpression() {
            MaxNativeAdAdapterListener listener = (MaxNativeAdAdapterListener)this.listenerReference.get();
            if (listener != null) {
                listener.onNativeAdDisplayed(new Bundle());
            }
        }

        public void onAdExpired() {
        }
    }
}

