/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters.prebid.managers;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.prebid.ParametersChecker;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;
import org.prebid.mobile.rendering.interstitial.rewarded.Reward;

public class MaxRewardedManager {
    private static final String TAG = MaxRewardedManager.class.getSimpleName();
    @Nullable
    private MaxRewardedAdapterListener maxListener;
    @Nullable
    private InterstitialController interstitialController;
    @Nullable
    private InterstitialControllerListener prebidListener;

    public void loadAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener maxListener) {
        this.maxListener = maxListener;
        this.loadAd(parameters, activity);
    }

    private void loadAd(MaxAdapterResponseParameters parameters, Activity activity) {
        String responseId = ParametersChecker.getResponseIdAndCheckKeywords(parameters, this::onError);
        if (responseId == null) {
            return;
        }
        activity.runOnUiThread(() -> {
            try {
                this.prebidListener = this.createRewardedListener();
                this.interstitialController = new InterstitialController((Context)activity, this.prebidListener);
                if (this.prebidListener != null) {
                    this.interstitialController.setRewardListener(() -> ((InterstitialControllerListener)this.prebidListener).onUserEarnedReward());
                }
                this.interstitialController.loadAd(responseId, true);
            }
            catch (AdException e) {
                String error = "Exception in Prebid interstitial controller (" + e.getMessage() + ")";
                Log.e((String)TAG, (String)error);
                this.onError(1006, error);
            }
        });
    }

    public void showAd() {
        if (this.interstitialController == null) {
            MaxAdapterError error = new MaxAdapterError(2010, "InterstitialController is null");
            if (this.maxListener != null) {
                this.maxListener.onRewardedAdDisplayFailed(error);
            }
            return;
        }
        this.interstitialController.show();
    }

    public void destroy() {
        if (this.interstitialController != null) {
            this.interstitialController.destroy();
        }
    }

    private void onError(int code, String error) {
        if (this.maxListener != null) {
            this.maxListener.onRewardedAdLoadFailed(new MaxAdapterError(code, error));
        } else {
            Log.e((String)TAG, (String)"Max interstitial listener must be not null!");
        }
    }

    public InterstitialControllerListener createRewardedListener() {
        return new InterstitialControllerListener(){

            public void onInterstitialReadyForDisplay() {
                if (MaxRewardedManager.this.maxListener != null) {
                    MaxRewardedManager.this.maxListener.onRewardedAdLoaded();
                }
            }

            public void onInterstitialClicked() {
                if (MaxRewardedManager.this.maxListener != null) {
                    MaxRewardedManager.this.maxListener.onRewardedAdClicked();
                }
            }

            public void onInterstitialFailedToLoad(AdException exception) {
                if (MaxRewardedManager.this.maxListener != null) {
                    MaxRewardedManager.this.maxListener.onRewardedAdLoadFailed(new MaxAdapterError(2002, "Ad failed: " + exception.getMessage()));
                }
            }

            public void onInterstitialDisplayed() {
                if (MaxRewardedManager.this.maxListener != null) {
                    MaxRewardedManager.this.maxListener.onRewardedAdDisplayed();
                }
            }

            public void onInterstitialClosed() {
                if (MaxRewardedManager.this.maxListener != null) {
                    MaxRewardedManager.this.maxListener.onRewardedAdHidden();
                }
            }

            public void onUserEarnedReward() {
                if (MaxRewardedManager.this.maxListener != null && MaxRewardedManager.this.interstitialController != null) {
                    final Reward reward = MaxRewardedManager.this.interstitialController.getReward();
                    MaxRewardedManager.this.maxListener.onUserRewarded(new MaxReward(){

                        public String getLabel() {
                            if (reward != null) {
                                return reward.getType();
                            }
                            return "";
                        }

                        public int getAmount() {
                            if (reward != null) {
                                return reward.getCount();
                            }
                            return 0;
                        }
                    });
                }
            }
        };
    }
}

