/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters.prebid.managers;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.prebid.ListenersCreator;
import com.applovin.mediation.adapters.prebid.ParametersChecker;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;

public class MaxInterstitialManager {
    private static final String TAG = MaxInterstitialManager.class.getSimpleName();
    @Nullable
    private MaxInterstitialAdapterListener maxListener;
    @Nullable
    private InterstitialController interstitialController;

    public void loadAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener maxListener) {
        this.maxListener = maxListener;
        this.loadAd(parameters, activity);
    }

    private void loadAd(MaxAdapterResponseParameters parameters, Activity activity) {
        String responseId = ParametersChecker.getResponseIdAndCheckKeywords(parameters, this::onError);
        if (responseId == null) {
            return;
        }
        activity.runOnUiThread(() -> {
            try {
                InterstitialControllerListener listener = this.createPrebidListener();
                this.interstitialController = new InterstitialController((Context)activity, listener);
                this.interstitialController.loadAd(responseId, false);
            }
            catch (AdException e) {
                String error = "Exception in Prebid interstitial controller (" + e.getMessage() + ")";
                Log.e((String)TAG, (String)error);
                this.onError(1006, error);
            }
        });
    }

    public void showAd() {
        if (this.interstitialController == null) {
            MaxAdapterError error = new MaxAdapterError(2010, "InterstitialController is null");
            if (this.maxListener != null) {
                this.maxListener.onInterstitialAdDisplayFailed(error);
            }
            return;
        }
        this.interstitialController.show();
    }

    public void destroy() {
        if (this.interstitialController != null) {
            this.interstitialController.destroy();
        }
    }

    private InterstitialControllerListener createPrebidListener() {
        if (this.maxListener != null) {
            return ListenersCreator.createInterstitialListener(this.maxListener);
        }
        Log.e((String)TAG, (String)"Max interstitial listener must be not null!");
        return null;
    }

    private void onError(int code, String error) {
        if (this.maxListener != null) {
            this.maxListener.onInterstitialAdLoadFailed(new MaxAdapterError(code, error));
        } else {
            Log.e((String)TAG, (String)"Max interstitial listener must be not null!");
        }
    }
}

