/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.prebidserver;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.core.AdSize;
import org.prebid.mobile.core.AdUnit;
import org.prebid.mobile.core.BidManager;
import org.prebid.mobile.core.BidResponse;
import org.prebid.mobile.core.DemandAdapter;
import org.prebid.mobile.core.ErrorCode;
import org.prebid.mobile.core.LogUtil;
import org.prebid.mobile.core.Prebid;
import org.prebid.mobile.core.TargetingParams;
import org.prebid.mobile.prebidserver.ServerConnector;
import org.prebid.mobile.prebidserver.internal.AdvertisingIDUtil;
import org.prebid.mobile.prebidserver.internal.Settings;

public class PrebidServerAdapter
implements DemandAdapter,
ServerConnector.ServerListener {
    private ArrayList<AdUnit> adUnits;
    private WeakReference<BidManager.BidResponseListener> weakReferenceLisenter;
    private String currentTID = null;

    @Override
    public void requestBid(Context context, BidManager.BidResponseListener bidResponseListener, ArrayList<AdUnit> adUnits) {
        this.adUnits = adUnits;
        this.weakReferenceLisenter = new WeakReference<BidManager.BidResponseListener>(bidResponseListener);
        JSONObject postData = this.getPostData(context, adUnits);
        if (Prebid.isSecureConnection()) {
            new ServerConnector(postData, this, "https://prebid.adnxs.com/pbs/v1/auction", context).execute(new Object[0]);
        } else {
            new ServerConnector(postData, this, "http://prebid.adnxs.com/pbs/v1/auction", context).execute(new Object[0]);
        }
    }

    @Override
    public void onServerResponded(JSONObject response) {
        BidManager.BidResponseListener bidResponseListener = (BidManager.BidResponseListener)this.weakReferenceLisenter.get();
        if (bidResponseListener != null) {
            HashMap responses = new HashMap();
            if (response == null || response.length() == 0) {
                LogUtil.e("empty server response.");
            } else {
                String tid;
                String status;
                try {
                    status = response.getString("status");
                }
                catch (JSONException e) {
                    LogUtil.e("Unable to retrieve response status.");
                    return;
                }
                if (status == null || !status.equals("OK")) {
                    LogUtil.e("Response status is not OK.");
                    return;
                }
                try {
                    tid = response.getString("tid");
                }
                catch (JSONException e) {
                    LogUtil.e("Unable to retrieve tid from response.");
                    return;
                }
                if (tid == null || !tid.equals(this.currentTID)) {
                    LogUtil.e("tid in response does not match the one in request.");
                    return;
                }
                JSONArray bids = null;
                try {
                    bids = response.getJSONArray("bids");
                }
                catch (JSONException e) {
                    LogUtil.e("Server response does not contain bids array");
                }
                if (bids != null && bids.length() != 0) {
                    int length = bids.length();
                    for (int i = 0; i < length; ++i) {
                        try {
                            JSONObject bid = bids.getJSONObject(i);
                            String code = bid.getString("code");
                            AdUnit adUnit = this.getAdUnitByCode(code);
                            if (adUnit == null) continue;
                            String cacheId = bid.getString("cache_id");
                            double bidPrice = bid.getDouble("price");
                            String bidder = bid.getString("bidder");
                            ArrayList<BidResponse> responseList = (ArrayList<BidResponse>)responses.get(adUnit);
                            if (responseList == null) {
                                responseList = new ArrayList<BidResponse>();
                            }
                            BidResponse newBid = new BidResponse(bidPrice, cacheId);
                            newBid.setBidderCode(bidder);
                            JSONObject targetingKeywords = bid.getJSONObject("ad_server_targeting");
                            Iterator keys = targetingKeywords.keys();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                newBid.addCustomKeyword(key, targetingKeywords.getString(key));
                            }
                            responseList.add(newBid);
                            responses.put(adUnit, responseList);
                            continue;
                        }
                        catch (JSONException e) {
                            LogUtil.e(String.format(Locale.ENGLISH, "Error parsing bids array: %s", bids.toString()));
                        }
                    }
                }
            }
            for (AdUnit adUnit : this.adUnits) {
                ArrayList results = (ArrayList)responses.get(adUnit);
                if (results != null && !results.isEmpty()) {
                    bidResponseListener.onBidSuccess(adUnit, results);
                    continue;
                }
                bidResponseListener.onBidFailure(adUnit, ErrorCode.NO_BIDS);
            }
        }
    }

    private AdUnit getAdUnitByCode(String code) {
        if (this.adUnits != null && !this.adUnits.isEmpty()) {
            for (AdUnit adUnit : this.adUnits) {
                if (!adUnit.getCode().equals(code)) continue;
                return adUnit;
            }
        }
        return null;
    }

    JSONObject getPostData(Context context, ArrayList<AdUnit> adUnits) {
        if (context != null) {
            AdvertisingIDUtil.retrieveAndSetAAID(context);
        }
        JSONObject postData = new JSONObject();
        try {
            JSONArray keywords;
            JSONObject user;
            JSONObject device;
            postData.put("cache_markup", 1);
            postData.put("sort_bids", 1);
            postData.put("tid", (Object)this.generateTID());
            postData.put("prebid_version", (Object)"0.21.0-pre");
            postData.put("account_id", (Object)Prebid.getAccountId());
            JSONArray adUnitConfigs = this.getAdUnitConfigs(adUnits);
            if (adUnitConfigs != null && adUnitConfigs.length() > 0) {
                postData.put("ad_units", (Object)adUnitConfigs);
            }
            if ((device = this.getDeviceObject(context)) != null && device.length() > 0) {
                postData.put("device", (Object)device);
            }
            JSONObject app = this.getAppObject(context);
            if (device != null && device.length() > 0) {
                postData.put("app", (Object)app);
            }
            if ((user = this.getUserObject()) != null && user.length() > 0) {
                postData.put("user", (Object)user);
            }
            if ((keywords = this.getCustomKeywordsArray()) != null && keywords.length() > 0) {
                postData.put("keywords", (Object)keywords);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return postData;
    }

    private String generateTID() {
        this.currentTID = UUID.randomUUID().toString();
        return this.currentTID;
    }

    private JSONArray getAdUnitConfigs(ArrayList<AdUnit> adUnits) {
        JSONArray adUnitConfigs = new JSONArray();
        for (AdUnit adUnit : adUnits) {
            try {
                JSONObject adUnitConfig = new JSONObject();
                adUnitConfig.put("config_id", (Object)adUnit.getConfigId());
                adUnitConfig.put("code", (Object)adUnit.getCode());
                JSONArray sizes = new JSONArray();
                for (AdSize size : adUnit.getSizes()) {
                    JSONObject sizeConfig = new JSONObject();
                    sizeConfig.put("w", size.getWidth());
                    sizeConfig.put("h", size.getHeight());
                    sizes.put((Object)sizeConfig);
                }
                adUnitConfig.put("sizes", (Object)sizes);
                adUnitConfigs.put((Object)adUnitConfig);
            }
            catch (JSONException jSONException) {}
        }
        return adUnitConfigs;
    }

    private JSONObject getDeviceObject(Context context) {
        JSONObject device = new JSONObject();
        try {
            Integer locDataAge;
            Integer locDataPrecision;
            Double lon;
            Double lat;
            if (!TextUtils.isEmpty((CharSequence)Settings.deviceMake)) {
                device.put("make", (Object)Settings.deviceMake);
            }
            if (!TextUtils.isEmpty((CharSequence)Settings.deviceModel)) {
                device.put("model", (Object)Settings.deviceModel);
            }
            if (context != null) {
                NetworkInfo wifi;
                String networkOperator;
                if (!TextUtils.isEmpty((CharSequence)Settings.userAgent)) {
                    device.put("ua", (Object)Settings.userAgent);
                }
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (!(Settings.getMCC() >= 0 && Settings.getMNC() >= 0 || TextUtils.isEmpty((CharSequence)(networkOperator = telephonyManager.getNetworkOperator())))) {
                    try {
                        Settings.setMCC(Integer.parseInt(networkOperator.substring(0, 3)));
                        Settings.setMNC(Integer.parseInt(networkOperator.substring(3)));
                    }
                    catch (Exception e) {
                        Settings.setMCC(-1);
                        Settings.setMNC(-1);
                    }
                }
                if (Settings.getMCC() > 0 && Settings.getMNC() > 0) {
                    device.put("mccmnc", (Object)String.format(Locale.ENGLISH, "%d-%d", Settings.getMCC(), Settings.getMNC()));
                }
                if (Settings.getCarrierName() == null) {
                    try {
                        Settings.setCarrierName(telephonyManager.getNetworkOperatorName());
                    }
                    catch (SecurityException ex) {
                        Settings.setCarrierName("");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)Settings.getCarrierName())) {
                    device.put("carrier", (Object)Settings.getCarrierName());
                }
                int connection_type = 0;
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                if (activeNetwork != null && activeNetwork.isConnected() && (wifi = cm.getNetworkInfo(1)) != null) {
                    connection_type = wifi.isConnected() ? 1 : 2;
                }
                device.put("connectiontype", connection_type);
            }
            Location lastLocation = null;
            Location appLocation = TargetingParams.getLocation();
            if (TargetingParams.getLocationEnabled()) {
                if (appLocation != null) {
                    lastLocation = appLocation;
                } else if (context != null && (context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 || context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0)) {
                    LocationManager lm = (LocationManager)context.getSystemService("location");
                    for (String provider_name : lm.getProviders(true)) {
                        Location l = lm.getLastKnownLocation(provider_name);
                        if (l == null) continue;
                        if (lastLocation == null) {
                            lastLocation = l;
                            continue;
                        }
                        if (l.getTime() <= 0L || lastLocation.getTime() <= 0L || l.getTime() <= lastLocation.getTime()) continue;
                        lastLocation = l;
                    }
                } else {
                    LogUtil.w("PrebidServer", "Location permissions ACCESS_COARSE_LOCATION and/or ACCESS_FINE_LOCATION aren\\'t set in the host app. This may affect demand.");
                }
            }
            if (appLocation != lastLocation) {
                TargetingParams.setLocation(lastLocation);
            }
            if (lastLocation != null) {
                if (TargetingParams.getLocationDecimalDigits() <= -1) {
                    lat = lastLocation.getLatitude();
                    lon = lastLocation.getLongitude();
                } else {
                    lat = Double.parseDouble(String.format(Locale.ENGLISH, "%." + TargetingParams.getLocationDecimalDigits() + "f", lastLocation.getLatitude()));
                    lon = Double.parseDouble(String.format(Locale.ENGLISH, "%." + TargetingParams.getLocationDecimalDigits() + "f", lastLocation.getLongitude()));
                }
                locDataPrecision = Math.round(lastLocation.getAccuracy());
                locDataAge = (int)Math.max(0L, System.currentTimeMillis() - lastLocation.getTime());
            } else {
                lat = null;
                lon = null;
                locDataAge = null;
                locDataPrecision = null;
            }
            JSONObject geo = new JSONObject();
            if (lat != null && lon != null) {
                geo.put("lat", (Object)lat);
                geo.put("lon", (Object)lon);
                if (locDataAge != null) {
                    geo.put("lastfix", (Object)locDataAge);
                }
                if (locDataPrecision != null) {
                    geo.put("accuracy", (Object)locDataPrecision);
                }
            }
            if (geo.length() > 0) {
                device.put("geo", (Object)geo);
            }
            long dev_time = System.currentTimeMillis();
            device.put("devtime", dev_time);
            device.put("lmt", AdvertisingIDUtil.isLimitAdTracking() ? 1 : 0);
            if (!AdvertisingIDUtil.isLimitAdTracking() && !TextUtils.isEmpty((CharSequence)AdvertisingIDUtil.getAAID())) {
                device.put("ifa", (Object)AdvertisingIDUtil.getAAID());
            }
            device.put("os", (Object)"android");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return device;
    }

    private JSONObject getAppObject(Context context) {
        if (TextUtils.isEmpty((CharSequence)Settings.getAppID()) && context != null) {
            Settings.setAppID(context.getApplicationContext().getPackageName());
        }
        JSONObject app = new JSONObject();
        try {
            app.put("bundle", (Object)Settings.getAppID());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return app;
    }

    private JSONObject getUserObject() {
        JSONObject user = new JSONObject();
        try {
            if (TargetingParams.getAge() > 0) {
                user.put("age", TargetingParams.getAge());
            }
            TargetingParams.GENDER gender = TargetingParams.getGender();
            int g = 0;
            switch (gender) {
                case FEMALE: {
                    g = 2;
                    break;
                }
                case MALE: {
                    g = 1;
                    break;
                }
                case UNKNOWN: {
                    g = 0;
                }
            }
            user.put("gender", g);
            if (!TextUtils.isEmpty((CharSequence)Settings.language)) {
                user.put("language", (Object)Settings.language);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return user;
    }

    private JSONArray getCustomKeywordsArray() {
        JSONArray keywords = new JSONArray();
        HashMap<String, ArrayList<String>> customKeywords = TargetingParams.getCustomKeywords();
        if (customKeywords != null && !customKeywords.isEmpty()) {
            for (String key : customKeywords.keySet()) {
                ArrayList<String> values = customKeywords.get(key);
                if (TextUtils.isEmpty((CharSequence)key) || values == null || values.isEmpty()) continue;
                try {
                    JSONObject key_val = new JSONObject();
                    key_val.put("key", (Object)key);
                    JSONArray val = new JSONArray(values);
                    key_val.put("value", (Object)val);
                    keywords.put((Object)key_val);
                }
                catch (JSONException jSONException) {}
            }
        }
        return keywords;
    }
}

