/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.prebid.mobile.core.LogUtil;

public class TargetingParams {
    private static final String TAG = LogUtil.getTagWithBase("TP");
    private static int age;
    private static GENDER gender;
    private static boolean locationEnabled;
    private static int locationDecimalDigits;
    private static HashMap<String, ArrayList<String>> customKeywords;
    private static Location location;

    private TargetingParams() {
    }

    @SuppressLint(value={"MissingPermission"})
    static void fetchLocationUpdates(Context appContext) {
        if (appContext != null) {
            Location lastLocation = null;
            if (locationEnabled) {
                LogUtil.d(TAG, "Updating location.");
                if (location != null) {
                    lastLocation = location;
                }
                if (appContext != null && (appContext.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 || appContext.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0)) {
                    LocationManager lm = (LocationManager)appContext.getSystemService("location");
                    for (String provider_name : lm.getProviders(true)) {
                        LogUtil.v(TAG, "Location provider_name::" + provider_name);
                        Location l = lm.getLastKnownLocation(provider_name);
                        if (l == null) continue;
                        if (lastLocation == null) {
                            lastLocation = l;
                            continue;
                        }
                        if (l.getTime() <= 0L || lastLocation.getTime() <= 0L || l.getTime() <= lastLocation.getTime()) continue;
                        lastLocation = l;
                    }
                } else {
                    LogUtil.d(TAG, "Location permissions ACCESS_COARSE_LOCATION and/or ACCESS_FINE_LOCATION aren\\'t set in the host app. Unable to update location data.");
                }
            }
            if (location != lastLocation) {
                location = lastLocation;
            }
        }
    }

    public static int getAge() {
        return age;
    }

    public static void setAge(int age) {
        TargetingParams.age = age;
    }

    public static GENDER getGender() {
        return gender;
    }

    public static void setGender(GENDER gender) {
        TargetingParams.gender = gender;
    }

    public static void setLocationEnabled(boolean enabled) {
        locationEnabled = enabled;
    }

    public static boolean getLocationEnabled() {
        return locationEnabled;
    }

    public static Location getLocation() {
        return location;
    }

    public static void setLocation(Location locationData) {
        location = locationData;
    }

    public static synchronized int getLocationDecimalDigits() {
        return locationDecimalDigits;
    }

    public static void setLocationDecimalDigits(int digitsAfterDecimal) {
        if (digitsAfterDecimal > 6) {
            locationDecimalDigits = 6;
            LogUtil.w(TAG, "Out of range input " + digitsAfterDecimal + ", set location digits after decimal to maximum 6");
        } else if (digitsAfterDecimal >= -1) {
            locationDecimalDigits = digitsAfterDecimal;
        } else {
            locationDecimalDigits = -1;
            LogUtil.w(TAG, "Invalid input " + digitsAfterDecimal + ", set location digits after decimal to default");
        }
    }

    public static synchronized HashMap<String, ArrayList<String>> getCustomKeywords() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        Set<String> keys = customKeywords.keySet();
        for (String key : keys) {
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> originalValues = customKeywords.get(key);
            if (originalValues != null) {
                for (String value : originalValues) {
                    values.add(value);
                }
            }
            result.put(key, values);
        }
        return result;
    }

    public static synchronized void removeCustomKeyword(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        customKeywords.remove(key);
    }

    public static synchronized void setCustomTargeting(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            LogUtil.w("Null/empty values passed in for custom targeting.");
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            customKeywords.put(key, values);
        }
    }

    public static synchronized void setCustomTargeting(String key, ArrayList<String> values) {
        if (TextUtils.isEmpty((CharSequence)key) || values == null || values.isEmpty()) {
            LogUtil.w("Null/empty values passed in for custom targeting.");
        } else {
            customKeywords.put(key, values);
        }
    }

    public static synchronized void clearCustomKeywords() {
        customKeywords.clear();
    }

    static {
        gender = GENDER.UNKNOWN;
        locationEnabled = false;
        locationDecimalDigits = -1;
        customKeywords = new HashMap();
    }

    public static enum GENDER {
        FEMALE,
        MALE,
        UNKNOWN;

    }
}

