/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.prebidserver.internal;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AdvertisingIDUtil {
    private static String aaid = null;
    private static boolean limitAdTracking = false;
    private static STATE state = STATE.NOT_FETCHED;

    public static synchronized String getAAID() {
        return aaid;
    }

    public static synchronized boolean isLimitAdTracking() {
        return limitAdTracking;
    }

    private static synchronized void setAAID(String aaid) {
        AdvertisingIDUtil.aaid = aaid;
    }

    private static synchronized void setLimitAdTracking(boolean limitAdTracking) {
        AdvertisingIDUtil.limitAdTracking = limitAdTracking;
    }

    public static void retrieveAndSetAAID(Context context) {
        if (STATE.FETCHED.equals((Object)state) || STATE.FETCHING.equals((Object)state) || context == null) {
            return;
        }
        AAIDTask getAAIDTask = new AAIDTask(context);
        if (Build.VERSION.SDK_INT >= 11) {
            getAAIDTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            getAAIDTask.execute(new Void[0]);
        }
    }

    private static class AAIDTask
    extends AsyncTask<Void, Void, Void> {
        private static final String cAdvertisingIdClientName = "com.google.android.gms.ads.identifier.AdvertisingIdClient";
        private static final String cAdvertisingIdClientInfoName = "com.google.android.gms.ads.identifier.AdvertisingIdClient$Info";
        private WeakReference<Context> context;

        private AAIDTask(Context context) {
            this.context = new WeakReference<Context>(context);
        }

        protected Void doInBackground(Void ... params) {
            state = STATE.FETCHING;
            try {
                Context callcontext = (Context)this.context.get();
                if (callcontext != null) {
                    Class<?> cInfo = Class.forName(cAdvertisingIdClientInfoName);
                    Class<?> cClient = Class.forName(cAdvertisingIdClientName);
                    Method mGetAdvertisingIdInfo = cClient.getMethod("getAdvertisingIdInfo", Context.class);
                    Method mGetId = cInfo.getMethod("getId", new Class[0]);
                    Method mIsLimitAdTrackingEnabled = cInfo.getMethod("isLimitAdTrackingEnabled", new Class[0]);
                    Object adInfoObject = cInfo.cast(mGetAdvertisingIdInfo.invoke(null, callcontext));
                    aaid = (String)mGetId.invoke(adInfoObject, new Object[0]);
                    limitAdTracking = (Boolean)mIsLimitAdTrackingEnabled.invoke(adInfoObject, new Object[0]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (limitAdTracking || TextUtils.isEmpty((CharSequence)aaid)) {
                state = STATE.FETCHED_BUT_LIMIT_TARGETING;
            } else {
                state = STATE.FETCHED;
            }
            return null;
        }
    }

    private static enum STATE {
        NOT_FETCHED,
        FETCHING,
        FETCHED_BUT_LIMIT_TARGETING,
        FETCHED;

    }
}

