/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.WebView;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class CacheManager {
    private WebView dfpWebCache;
    private HashMap<String, String> sdkCache;
    private static CacheManager cache;

    private CacheManager(Context context) {
        this.setupBidCleanUpRunnable();
        this.setupWebCache(context);
        this.setupSDKCache();
    }

    public static void init(Context context) {
        if (cache == null) {
            cache = new CacheManager(context);
        }
    }

    public static CacheManager getCacheManager() {
        return cache;
    }

    private void setupBidCleanUpRunnable() {
        final Handler handler = new Handler(Looper.getMainLooper());
        Runnable cleanCache = new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                CacheManager.this.removeCache(now);
                handler.postDelayed((Runnable)this, 270000L);
            }
        };
        handler.post(cleanCache);
    }

    private void removeCache(long now) {
        String removeWebCache = "<html><script>var currentTime = " + String.valueOf(now) + ";\nvar toBeDeleted = [];\n\nfor(i = 0; i< localStorage.length; i ++) {\n\tif (localStorage.key(i).startsWith('Prebid_')) {\n\t\tcreatedTime = localStorage.key(i).split('_')[2];\n\t\tif (( currentTime - createdTime) > 270000){\n\t\t\ttoBeDeleted.push(localStorage.key(i));\n\t\t}\n\t}\n}\n\nfor ( i = 0; i< toBeDeleted.length; i ++) {\n\tlocalStorage.removeItem(toBeDeleted[i]);\n}</script></html>";
        if (this.dfpWebCache != null) {
            this.dfpWebCache.loadDataWithBaseURL("https://pubads.g.doubleclick.net", removeWebCache, "text/html", null, null);
        }
        if (this.sdkCache != null) {
            ArrayList<String> toBeDeleted = new ArrayList<String>();
            for (String key : this.sdkCache.keySet()) {
                long createdTime = Long.valueOf(key.split("_")[2]);
                if (now - createdTime <= 270000L) continue;
                toBeDeleted.add(key);
            }
            for (String key : toBeDeleted) {
                this.sdkCache.remove(key);
            }
        }
    }

    public String saveCache(String bid, String format) {
        if (TextUtils.isEmpty((CharSequence)bid)) {
            return null;
        }
        String cacheId = "Prebid_" + RandomStringUtils.randomAlphabetic((int)8) + "_" + String.valueOf(System.currentTimeMillis());
        if ("html".equals(format)) {
            this.saveCacheForWeb(cacheId, bid);
        } else if ("demand_sdk".equals(format)) {
            this.saveCacheForSDK(cacheId, bid);
        }
        return cacheId;
    }

    private void setupWebCache(final Context context) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                CacheManager.this.dfpWebCache = new WebView(context);
                CacheManager.this.dfpWebCache.getSettings().setDomStorageEnabled(true);
                CacheManager.this.dfpWebCache.getSettings().setJavaScriptEnabled(true);
            }
        });
    }

    private void saveCacheForWeb(final String cacheId, final String bid) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                String escapedBid = StringEscapeUtils.escapeEcmaScript((String)bid);
                String result = "<html><script> localStorage.setItem('" + cacheId + "', '" + escapedBid + "');</script></html>";
                if (CacheManager.this.dfpWebCache != null) {
                    CacheManager.this.dfpWebCache.loadDataWithBaseURL("https://pubads.g.doubleclick.net", result, "text/html", null, null);
                }
            }
        });
    }

    private void setupSDKCache() {
        if (this.sdkCache == null) {
            this.sdkCache = new HashMap();
        }
    }

    private void saveCacheForSDK(String cacheId, String bid) {
        if (this.sdkCache != null) {
            this.sdkCache.put(cacheId, bid);
        }
    }

    private String getCacheForSDK(String cacheId) {
        if (this.sdkCache != null) {
            return this.sdkCache.remove(cacheId);
        }
        return null;
    }
}

