/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.prebid.mobile.core.AdType;
import org.prebid.mobile.core.AdUnit;
import org.prebid.mobile.core.BidManager;
import org.prebid.mobile.core.CacheManager;
import org.prebid.mobile.core.DemandAdapter;
import org.prebid.mobile.core.InterstitialAdUnit;
import org.prebid.mobile.core.LogUtil;
import org.prebid.mobile.core.PrebidException;

public class Prebid {
    private static String PREBID_SERVER = "org.prebid.mobile.prebidserver.PrebidServerAdapter";
    private static String MOPUB_ADVIEW_CLASS = "com.mopub.mobileads.MoPubView";
    private static String MOPUB_INTERSTITIAL_CLASS = "com.mopub.mobileads.MoPubInterstitial";
    private static String DFP_ADREQUEST_CLASS = "com.google.android.gms.ads.doubleclick.PublisherAdRequest";
    private static boolean secureConnection = true;
    private static String accountId;
    private static final int kMoPubQueryStringLimit = 4000;
    private static boolean useLocalCache;
    private static Host host;
    private static AdServer adServer;
    private static final LinkedList<String> usedKeywordsList;
    private static final Set<String> usedKeywordKeys;

    public static AdServer getAdServer() {
        return adServer;
    }

    public static Host getHost() {
        return host;
    }

    public static boolean useLocalCache() {
        return useLocalCache;
    }

    @Deprecated
    public static void init(Context context, ArrayList<AdUnit> adUnits, String accountId) throws PrebidException {
        LogUtil.i("Initializing with a list of AdUnits");
        if (context == null) {
            throw new PrebidException(PrebidException.PrebidError.NULL_CONTEXT);
        }
        if (TextUtils.isEmpty((CharSequence)accountId)) {
            throw new PrebidException(PrebidException.PrebidError.INVALID_ACCOUNT_ID);
        }
        Prebid.accountId = accountId;
        if (adUnits == null || adUnits.isEmpty()) {
            throw new PrebidException(PrebidException.PrebidError.EMPTY_ADUNITS);
        }
        for (AdUnit adUnit : adUnits) {
            if (adUnit.getAdType().equals((Object)AdType.BANNER) && adUnit.getSizes().isEmpty()) {
                LogUtil.e("Sizes are not added to BannerAdUnit with code: " + adUnit.getCode());
                throw new PrebidException(PrebidException.PrebidError.BANNER_AD_UNIT_NO_SIZE);
            }
            if (adUnit.getAdType().equals((Object)AdType.INTERSTITIAL)) {
                ((InterstitialAdUnit)adUnit).setInterstitialSizes(context);
            }
            BidManager.registerAdUnit(adUnit);
        }
        try {
            Class<?> adapterClass = Class.forName(PREBID_SERVER);
            DemandAdapter adapter = (DemandAdapter)adapterClass.newInstance();
            if (adapter == null) {
                throw new PrebidException(PrebidException.PrebidError.UNABLE_TO_INITIALIZE_DEMAND_SOURCE);
            }
            BidManager.adapter = adapter;
        }
        catch (Exception e) {
            throw new PrebidException(PrebidException.PrebidError.UNABLE_TO_INITIALIZE_DEMAND_SOURCE);
        }
        BidManager.setBidsExpirationRunnable(context);
        CacheManager.init(context);
        BidManager.requestBidsForAdUnits(context, adUnits);
    }

    @Deprecated
    public static void init(Context context, ArrayList<AdUnit> adUnits, String accountId, AdServer adServer) throws PrebidException {
        LogUtil.i("Initializing with a list of AdUnits");
        if (context == null) {
            throw new PrebidException(PrebidException.PrebidError.NULL_CONTEXT);
        }
        if (TextUtils.isEmpty((CharSequence)accountId)) {
            throw new PrebidException(PrebidException.PrebidError.INVALID_ACCOUNT_ID);
        }
        Prebid.accountId = accountId;
        Prebid.adServer = adServer;
        if (AdServer.MOPUB.equals((Object)Prebid.adServer)) {
            useLocalCache = false;
        }
        if (adUnits == null || adUnits.isEmpty()) {
            throw new PrebidException(PrebidException.PrebidError.EMPTY_ADUNITS);
        }
        for (AdUnit adUnit : adUnits) {
            if (adUnit.getAdType().equals((Object)AdType.BANNER) && adUnit.getSizes().isEmpty()) {
                LogUtil.e("Sizes are not added to BannerAdUnit with code: " + adUnit.getCode());
                throw new PrebidException(PrebidException.PrebidError.BANNER_AD_UNIT_NO_SIZE);
            }
            if (adUnit.getAdType().equals((Object)AdType.INTERSTITIAL)) {
                ((InterstitialAdUnit)adUnit).setInterstitialSizes(context);
            }
            BidManager.registerAdUnit(adUnit);
        }
        try {
            Class<?> adapterClass = Class.forName(PREBID_SERVER);
            DemandAdapter adapter = (DemandAdapter)adapterClass.newInstance();
            if (adapter == null) {
                throw new PrebidException(PrebidException.PrebidError.UNABLE_TO_INITIALIZE_DEMAND_SOURCE);
            }
            BidManager.adapter = adapter;
        }
        catch (Exception e) {
            throw new PrebidException(PrebidException.PrebidError.UNABLE_TO_INITIALIZE_DEMAND_SOURCE);
        }
        BidManager.setBidsExpirationRunnable(context);
        CacheManager.init(context);
        BidManager.requestBidsForAdUnits(context, adUnits);
    }

    public static void init(Context context, ArrayList<AdUnit> adUnits, String accountId, AdServer adServer, Host host) throws PrebidException {
        LogUtil.i("Initializing with a list of AdUnits");
        if (context == null) {
            throw new PrebidException(PrebidException.PrebidError.NULL_CONTEXT);
        }
        if (TextUtils.isEmpty((CharSequence)accountId)) {
            throw new PrebidException(PrebidException.PrebidError.INVALID_ACCOUNT_ID);
        }
        Prebid.accountId = accountId;
        Prebid.adServer = adServer;
        if (AdServer.MOPUB.equals((Object)Prebid.adServer)) {
            useLocalCache = false;
        }
        if (host == null) {
            throw new PrebidException(PrebidException.PrebidError.NULL_HOST);
        }
        Prebid.host = host;
        if (adUnits == null || adUnits.isEmpty()) {
            throw new PrebidException(PrebidException.PrebidError.EMPTY_ADUNITS);
        }
        for (AdUnit adUnit : adUnits) {
            if (adUnit.getAdType().equals((Object)AdType.BANNER) && adUnit.getSizes().isEmpty()) {
                LogUtil.e("Sizes are not added to BannerAdUnit with code: " + adUnit.getCode());
                throw new PrebidException(PrebidException.PrebidError.BANNER_AD_UNIT_NO_SIZE);
            }
            if (adUnit.getAdType().equals((Object)AdType.INTERSTITIAL)) {
                ((InterstitialAdUnit)adUnit).setInterstitialSizes(context);
            }
            BidManager.registerAdUnit(adUnit);
        }
        try {
            Class<?> adapterClass = Class.forName(PREBID_SERVER);
            DemandAdapter adapter = (DemandAdapter)adapterClass.newInstance();
            if (adapter == null) {
                throw new PrebidException(PrebidException.PrebidError.UNABLE_TO_INITIALIZE_DEMAND_SOURCE);
            }
            BidManager.adapter = adapter;
        }
        catch (Exception e) {
            throw new PrebidException(PrebidException.PrebidError.UNABLE_TO_INITIALIZE_DEMAND_SOURCE);
        }
        BidManager.setBidsExpirationRunnable(context);
        CacheManager.init(context);
        BidManager.requestBidsForAdUnits(context, adUnits);
    }

    public static void attachBids(Object adObj, String adUnitCode, Context context) {
        if (adObj != null) {
            Prebid.detachUsedBid(adObj);
            if (adObj.getClass() == Prebid.getClassFromString(MOPUB_ADVIEW_CLASS) || adObj.getClass() == Prebid.getClassFromString(MOPUB_INTERSTITIAL_CLASS)) {
                Prebid.handleMoPubKeywordsUpdate(adObj, adUnitCode, context);
            } else if (adObj.getClass() == Prebid.getClassFromString(DFP_ADREQUEST_CLASS)) {
                Prebid.handleDFPCustomTargetingUpdate(adObj, adUnitCode, context);
            }
        }
    }

    public static void detachUsedBid(Object adObj) {
        if (adObj != null) {
            if (adObj.getClass() == Prebid.getClassFromString(MOPUB_ADVIEW_CLASS)) {
                Prebid.removeUsedKeywordsForMoPub(adObj);
            } else if (adObj.getClass() == Prebid.getClassFromString(DFP_ADREQUEST_CLASS)) {
                Prebid.removeUsedCustomTargetingForDFP(adObj);
            }
        }
    }

    public static void attachBidsWhenReady(final Object adObject, String adUnitCode, final OnAttachCompleteListener listener, int timeOut, final Context context) {
        BidManager.getKeywordsWhenReadyForAdUnit(adUnitCode, timeOut, new BidManager.BidReadyListener(){

            @Override
            public void onBidReady(String adUnitCode) {
                Prebid.attachBids(adObject, adUnitCode, context);
                listener.onAttachComplete(adObject);
            }
        });
    }

    private static Class getClassFromString(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Object callMethodOnObject(Object object, String methodName, Object ... params) {
        try {
            int len = params.length;
            Class[] classes = new Class[len];
            for (int i = 0; i < len; ++i) {
                classes[i] = params[i].getClass();
            }
            Method method = object.getClass().getMethod(methodName, classes);
            return method.invoke(object, params);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMoPubKeywordsUpdate(Object adViewObj, String adUnitCode, Context context) {
        ArrayList<Pair<String, String>> keywordPairs = BidManager.getKeywordsForAdUnit(adUnitCode, context);
        if (keywordPairs != null && !keywordPairs.isEmpty()) {
            StringBuilder keywords = new StringBuilder();
            for (Pair<String, String> p : keywordPairs) {
                keywords.append((String)p.first).append(":").append((String)p.second).append(",");
            }
            String prebidKeywords = keywords.toString();
            String adViewKeywords = (String)Prebid.callMethodOnObject(adViewObj, "getKeywords", new Object[0]);
            adViewKeywords = !TextUtils.isEmpty((CharSequence)adViewKeywords) ? prebidKeywords + adViewKeywords : prebidKeywords;
            if (adViewKeywords.length() <= 4000) {
                LinkedList<String> linkedList = usedKeywordsList;
                synchronized (linkedList) {
                    usedKeywordsList.add(prebidKeywords);
                }
                Prebid.callMethodOnObject(adViewObj, "setKeywords", adViewKeywords);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeUsedKeywordsForMoPub(Object adViewObj) {
        String adViewKeywords = (String)Prebid.callMethodOnObject(adViewObj, "getKeywords", new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)adViewKeywords) && !usedKeywordsList.isEmpty()) {
            LinkedList<String> tempUsedKeywords = new LinkedList<String>();
            for (String usedKeyword : usedKeywordsList) {
                if (TextUtils.isEmpty((CharSequence)usedKeyword) || !adViewKeywords.contains(usedKeyword)) continue;
                adViewKeywords = adViewKeywords.replace(usedKeyword, "");
                tempUsedKeywords.add(usedKeyword);
            }
            Prebid.callMethodOnObject(adViewObj, "setKeywords", adViewKeywords);
            for (String string : tempUsedKeywords) {
                LinkedList<String> linkedList = usedKeywordsList;
                synchronized (linkedList) {
                    usedKeywordsList.remove(string);
                }
            }
        }
    }

    private static void handleDFPCustomTargetingUpdate(Object adRequestObj, String adUnitCode, Context context) {
        ArrayList<Pair<String, String>> prebidKeywords;
        Bundle bundle = (Bundle)Prebid.callMethodOnObject(adRequestObj, "getCustomTargeting", new Object[0]);
        if (bundle != null && (prebidKeywords = BidManager.getKeywordsForAdUnit(adUnitCode, context)) != null && !prebidKeywords.isEmpty()) {
            for (Pair<String, String> keywordPair : prebidKeywords) {
                bundle.putString((String)keywordPair.first, (String)keywordPair.second);
                usedKeywordKeys.add((String)keywordPair.first);
            }
        }
    }

    private static void removeUsedCustomTargetingForDFP(Object adRequestObj) {
        Bundle bundle = (Bundle)Prebid.callMethodOnObject(adRequestObj, "getCustomTargeting", new Object[0]);
        if (bundle != null) {
            for (String key : usedKeywordKeys) {
                bundle.remove(key);
            }
        }
    }

    public static String getAccountId() {
        return accountId;
    }

    public static boolean isSecureConnection() {
        return secureConnection;
    }

    public static void shouldLoadOverSecureConnection(boolean secureConnection) {
        if (adServer.equals((Object)AdServer.MOPUB)) {
            Prebid.secureConnection = secureConnection;
        }
    }

    static {
        useLocalCache = true;
        host = Host.APPNEXUS;
        adServer = AdServer.UNKNOWN;
        usedKeywordsList = new LinkedList();
        usedKeywordKeys = new HashSet<String>();
    }

    public static interface OnAttachCompleteListener {
        public void onAttachComplete(Object var1);
    }

    public static enum Host {
        APPNEXUS,
        RUBICON;

    }

    public static enum AdServer {
        DFP,
        MOPUB,
        UNKNOWN;

    }
}

