/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class CacheManager {
    private WebView dfpWebCache;
    private HashMap<String, String> sdkCache;
    private static CacheManager cache;

    private CacheManager(Context context) {
        Handler handler = new Handler(Looper.getMainLooper());
        this.setupBidCleanUpRunnable(handler);
        this.setupWebCache(context, handler);
        this.setupSDKCache();
    }

    public static void init(Context context) {
        if (cache == null) {
            cache = new CacheManager(context);
        }
    }

    public static CacheManager getCacheManager() {
        return cache;
    }

    private void setupBidCleanUpRunnable(Handler handler) {
        handler.post((Runnable)new BidCleanUpRunnable(this, handler));
    }

    private void removeCache(long now) {
        String removeWebCache = "<html><script>var currentTime = " + String.valueOf(now) + ";\nvar toBeDeleted = [];\n\nfor(i = 0; i< localStorage.length; i ++) {\n\tif (localStorage.key(i).startsWith('Prebid_')) {\n\t\tcreatedTime = localStorage.key(i).split('_')[2];\n\t\tif (( currentTime - createdTime) > 270000){\n\t\t\ttoBeDeleted.push(localStorage.key(i));\n\t\t}\n\t}\n}\n\nfor ( i = 0; i< toBeDeleted.length; i ++) {\n\tlocalStorage.removeItem(toBeDeleted[i]);\n}</script></html>";
        if (this.dfpWebCache != null) {
            this.dfpWebCache.loadDataWithBaseURL("https://pubads.g.doubleclick.net", removeWebCache, "text/html", null, null);
        }
        if (this.sdkCache != null) {
            ArrayList<String> toBeDeleted = new ArrayList<String>();
            for (String key : this.sdkCache.keySet()) {
                long createdTime = Long.valueOf(key.split("_")[2]);
                if (now - createdTime <= 270000L) continue;
                toBeDeleted.add(key);
            }
            for (String key : toBeDeleted) {
                this.sdkCache.remove(key);
            }
        }
    }

    public String saveCache(String bid, String format) {
        if (TextUtils.isEmpty((CharSequence)bid)) {
            return null;
        }
        String cacheId = "Prebid_" + RandomStringUtils.randomAlphabetic((int)8) + "_" + String.valueOf(System.currentTimeMillis());
        if ("html".equals(format)) {
            this.saveCacheForWeb(cacheId, bid);
        } else if ("demand_sdk".equals(format)) {
            this.saveCacheForSDK(cacheId, bid);
        }
        return cacheId;
    }

    private void setupWebCache(Context context, Handler handler) {
        handler.postAtFrontOfQueue((Runnable)new WebCacheInitializer(this, context));
    }

    private void saveCacheForWeb(String cacheId, String bid) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postAtFrontOfQueue((Runnable)new SaveCacheForWebRunnable(this, cacheId, bid));
    }

    private void setupSDKCache() {
        if (this.sdkCache == null) {
            this.sdkCache = new HashMap();
        }
    }

    private void saveCacheForSDK(String cacheId, String bid) {
        if (this.sdkCache != null) {
            this.sdkCache.put(cacheId, bid);
        }
    }

    private String getCacheForSDK(String cacheId) {
        if (this.sdkCache != null) {
            return this.sdkCache.remove(cacheId);
        }
        return null;
    }

    private static class SaveCacheForWebRunnable
    implements Runnable {
        private final WeakReference<CacheManager> cacheManagerWeakRef;
        private final String cacheId;
        private final String bid;

        SaveCacheForWebRunnable(CacheManager cacheManager, String cacheId, String bid) {
            this.cacheManagerWeakRef = new WeakReference<CacheManager>(cacheManager);
            this.cacheId = cacheId;
            this.bid = bid;
        }

        @Override
        public void run() {
            CacheManager cacheManager = (CacheManager)this.cacheManagerWeakRef.get();
            if (cacheManager == null) {
                return;
            }
            if (cacheManager.dfpWebCache == null) {
                return;
            }
            String escapedBid = StringEscapeUtils.escapeEcmaScript((String)this.bid);
            String result = "<html><script> localStorage.setItem('" + this.cacheId + "', '" + escapedBid + "');</script></html>";
            cacheManager.dfpWebCache.loadDataWithBaseURL("https://pubads.g.doubleclick.net", result, "text/html", null, null);
        }
    }

    private static class WebCacheInitializer
    implements Runnable {
        private final WeakReference<CacheManager> cacheManagerWeakRef;
        private final WeakReference<Context> contextWeakRef;

        WebCacheInitializer(CacheManager cacheManager, Context context) {
            this.cacheManagerWeakRef = new WeakReference<CacheManager>(cacheManager);
            this.contextWeakRef = new WeakReference<Context>(context);
        }

        @Override
        public void run() {
            CacheManager cacheManager = (CacheManager)this.cacheManagerWeakRef.get();
            if (cacheManager == null) {
                return;
            }
            Context context = (Context)this.contextWeakRef.get();
            if (context == null) {
                return;
            }
            try {
                cacheManager.dfpWebCache = new WebView(context);
                WebSettings webSettings = cacheManager.dfpWebCache.getSettings();
                if (webSettings != null) {
                    webSettings.setDomStorageEnabled(true);
                    webSettings.setJavaScriptEnabled(true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class BidCleanUpRunnable
    implements Runnable {
        private final WeakReference<CacheManager> cacheManagerWeakRef;
        private final Handler handler;

        BidCleanUpRunnable(CacheManager cacheManager, Handler handler) {
            this.cacheManagerWeakRef = new WeakReference<CacheManager>(cacheManager);
            this.handler = handler;
        }

        @Override
        public void run() {
            CacheManager cacheManager = (CacheManager)this.cacheManagerWeakRef.get();
            if (cacheManager == null) {
                return;
            }
            cacheManager.removeCache(System.currentTimeMillis());
            this.handler.postDelayed((Runnable)this, 270000L);
        }
    }
}

