/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import java.util.Random;

final class StringUtils {
    private static final Random RANDOM = new Random();

    private StringUtils() {
    }

    public static String randomLowercaseAlphabetic(int count) {
        return StringUtils.randomLowercaseAlphabetic(count, RANDOM);
    }

    static String randomLowercaseAlphabetic(int count, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Invalid count value: " + count + " is less than 0.");
        }
        int start = 97;
        int end = 123;
        StringBuilder sb = new StringBuilder(count);
        int gap = end - start;
        while (count-- != 0) {
            int codePoint = random.nextInt(gap) + start;
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }

    public static String escapeEcmaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length() + 50);
        int len = str.length();
        block8: for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            switch (c) {
                case '\"': 
                case '\'': 
                case '/': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                default: {
                    int cp = Character.codePointAt(str, pos);
                    if (cp < 32 || cp > 127) {
                        if (cp > 65535) {
                            char[] surrogatePair = Character.toChars(cp);
                            sb.append("\\u");
                            sb.append(Integer.toHexString(surrogatePair[0]));
                            sb.append("\\u");
                            sb.append(Integer.toHexString(surrogatePair[1]));
                        } else {
                            sb.append(String.format("\\u%04x", cp));
                        }
                        pos += Character.charCount(cp) - 1;
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

