/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.prebidserver;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.core.AdSize;
import org.prebid.mobile.core.AdType;
import org.prebid.mobile.core.AdUnit;
import org.prebid.mobile.core.BidManager;
import org.prebid.mobile.core.BidResponse;
import org.prebid.mobile.core.CacheManager;
import org.prebid.mobile.core.DemandAdapter;
import org.prebid.mobile.core.ErrorCode;
import org.prebid.mobile.core.LogUtil;
import org.prebid.mobile.core.Prebid;
import org.prebid.mobile.core.TargetingParams;
import org.prebid.mobile.prebidserver.ServerConnector;
import org.prebid.mobile.prebidserver.internal.AdvertisingIDUtil;
import org.prebid.mobile.prebidserver.internal.Settings;

public class PrebidServerAdapter
implements DemandAdapter,
ServerConnector.ServerListener {
    private ArrayList<AdUnit> adUnits;
    private WeakReference<BidManager.BidResponseListener> weakReferenceLisenter;
    private final int ADUNITS_PER_REQUEST = 10;

    @Override
    public void requestBid(Context context, BidManager.BidResponseListener bidResponseListener, ArrayList<AdUnit> adUnits) {
        this.adUnits = adUnits;
        this.weakReferenceLisenter = new WeakReference<BidManager.BidResponseListener>(bidResponseListener);
        ArrayList<ArrayList<AdUnit>> adUnitsList = this.batchAdUnits(adUnits);
        if (adUnitsList != null && !adUnitsList.isEmpty()) {
            for (ArrayList<AdUnit> batchedAdUnits : adUnitsList) {
                JSONObject postData = this.getPostData(context, batchedAdUnits);
                LogUtil.d("PrebidServer", "Prebid Mobile send request with: " + postData.toString());
                new ServerConnector(postData, this, this.getHost(), context).execute(new Object[0]);
            }
        }
    }

    ArrayList<ArrayList<AdUnit>> batchAdUnits(ArrayList<AdUnit> adUnits) {
        ArrayList<ArrayList<AdUnit>> adUnitsList = new ArrayList<ArrayList<AdUnit>>();
        int len = adUnits.size();
        int i = len / 10;
        int j = len % 10;
        for (int m = 0; m < i; ++m) {
            ArrayList<AdUnit> splitAdUnitsList = new ArrayList<AdUnit>();
            for (int n = 0; n < 10; ++n) {
                splitAdUnitsList.add(adUnits.get(m * 10 + n));
            }
            adUnitsList.add(splitAdUnitsList);
        }
        if (j > 0) {
            ArrayList<AdUnit> splitAdUnitsList = new ArrayList<AdUnit>();
            for (int n = 0; n < j; ++n) {
                splitAdUnitsList.add(adUnits.get(i * 10 + n));
            }
            adUnitsList.add(splitAdUnitsList);
        }
        return adUnitsList;
    }

    String getHost() {
        String host = null;
        switch (Prebid.getHost()) {
            case APPNEXUS: {
                host = Prebid.isSecureConnection() ? "https://prebid.adnxs.com/pbs/v1/openrtb2/auction" : "http://prebid.adnxs.com/pbs/v1/openrtb2/auction";
                break;
            }
            case RUBICON: {
                host = Prebid.isSecureConnection() ? "https://prebid-server.rubiconproject.com/openrtb2/auction" : "http://prebid-server.rubiconproject.com/openrtb2/auction";
            }
        }
        return host;
    }

    @Override
    public void onServerResponded(JSONObject response) {
        BidManager.BidResponseListener bidResponseListener = (BidManager.BidResponseListener)this.weakReferenceLisenter.get();
        if (bidResponseListener != null) {
            HashMap responses = new HashMap();
            if (response == null || response.length() == 0) {
                LogUtil.e("PrebidServer", "Server responded with empty response.");
            } else {
                LogUtil.d("PrebidServer", "Server responded with: " + response.toString());
                JSONArray seatbid = null;
                try {
                    seatbid = response.getJSONArray("seatbid");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (seatbid != null && seatbid.length() > 0) {
                    int len = seatbid.length();
                    for (int i = 0; i < len; ++i) {
                        try {
                            JSONObject seat = seatbid.getJSONObject(i);
                            String bidderName = seat.getString("seat");
                            JSONArray bids = seat.getJSONArray("bid");
                            if (bids == null || bids.length() <= 0) continue;
                            int n = bids.length();
                            for (int j = 0; j < n; ++j) {
                                String key;
                                Iterator keys;
                                JSONObject bid = bids.getJSONObject(j);
                                String impId = bid.getString("impid");
                                AdUnit adUnit = this.getAdUnitByCode(impId);
                                if (adUnit == null) continue;
                                double bidPrice = bid.getDouble("price");
                                ArrayList<BidResponse> responseList = (ArrayList<BidResponse>)responses.get(adUnit);
                                if (responseList == null) {
                                    responseList = new ArrayList<BidResponse>();
                                }
                                BidResponse newBid = null;
                                JSONObject targetingKeywords = bid.getJSONObject("ext").getJSONObject("prebid").getJSONObject("targeting");
                                if (Prebid.useLocalCache()) {
                                    String format = targetingKeywords.getString("hb_creative_loadtype");
                                    String cacheId = CacheManager.getCacheManager().saveCache(bid.toString(), format);
                                    newBid = new BidResponse(bidPrice, cacheId);
                                    newBid.setBidderCode(bidderName);
                                    keys = targetingKeywords.keys();
                                    while (keys.hasNext()) {
                                        key = (String)keys.next();
                                        newBid.addCustomKeyword(key, targetingKeywords.getString(key));
                                    }
                                    String cacheIdKey = "hb_cache_id_" + bidderName;
                                    cacheIdKey = cacheIdKey.substring(0, Math.min(cacheIdKey.length(), 20));
                                    newBid.addCustomKeyword(cacheIdKey, cacheId);
                                } else {
                                    String cacheId = null;
                                    Iterator keyIterator = targetingKeywords.keys();
                                    while (keyIterator.hasNext()) {
                                        String key2 = (String)keyIterator.next();
                                        if (!key2.startsWith("hb_cache_id_")) continue;
                                        cacheId = targetingKeywords.getString(key2);
                                    }
                                    if (cacheId != null) {
                                        newBid = new BidResponse(bidPrice, cacheId);
                                        newBid.setBidderCode(bidderName);
                                        keys = targetingKeywords.keys();
                                        while (keys.hasNext()) {
                                            key = (String)keys.next();
                                            newBid.addCustomKeyword(key, targetingKeywords.getString(key));
                                        }
                                    }
                                }
                                if (newBid != null) {
                                    responseList.add(newBid);
                                }
                                responses.put(adUnit, responseList);
                            }
                            continue;
                        }
                        catch (JSONException seat) {
                            // empty catch block
                        }
                    }
                }
            }
            for (AdUnit adUnit : this.adUnits) {
                ArrayList results = (ArrayList)responses.get(adUnit);
                if (results != null && !results.isEmpty()) {
                    if (Prebid.useLocalCache()) {
                        BidResponse topBid = null;
                        for (int i = 0; i < results.size(); ++i) {
                            for (Pair pair : ((BidResponse)results.get(i)).getCustomKeywords()) {
                                if (!((String)pair.first).equals("hb_bidder")) continue;
                                topBid = (BidResponse)results.get(i);
                            }
                        }
                        if (topBid != null) {
                            topBid.addCustomKeyword("hb_cache_id", topBid.getCreative());
                        }
                        bidResponseListener.onBidSuccess(adUnit, results);
                        continue;
                    }
                    String topCacheId = null;
                    for (BidResponse bid : results) {
                        ArrayList<Pair<String, String>> arrayList = bid.getCustomKeywords();
                        for (Pair<String, String> pair : arrayList) {
                            if (!((String)pair.first).equals("hb_cache_id")) continue;
                            topCacheId = (String)pair.second;
                        }
                    }
                    if (topCacheId != null) {
                        bidResponseListener.onBidSuccess(adUnit, results);
                        continue;
                    }
                    bidResponseListener.onBidFailure(adUnit, ErrorCode.NO_BIDS);
                    continue;
                }
                bidResponseListener.onBidFailure(adUnit, ErrorCode.NO_BIDS);
            }
        }
    }

    private AdUnit getAdUnitByCode(String code) {
        if (this.adUnits != null && !this.adUnits.isEmpty()) {
            for (AdUnit adUnit : this.adUnits) {
                if (!adUnit.getCode().equals(code)) continue;
                return adUnit;
            }
        }
        return null;
    }

    JSONObject getPostData(Context context, ArrayList<AdUnit> adUnits) {
        if (context != null) {
            AdvertisingIDUtil.retrieveAndSetAAID(context);
            Settings.update(context);
        }
        JSONObject postData = new JSONObject();
        try {
            JSONObject ext;
            JSONObject regs;
            JSONObject user;
            JSONObject device;
            String id = UUID.randomUUID().toString();
            postData.put("id", (Object)id);
            JSONObject source = new JSONObject();
            source.put("tid", (Object)id);
            postData.put("source", (Object)source);
            JSONArray imps = this.getImps(adUnits);
            if (imps != null && imps.length() > 0) {
                postData.put("imp", (Object)imps);
            }
            if ((device = this.getDeviceObject(context)) != null && device.length() > 0) {
                postData.put("device", (Object)device);
            }
            JSONObject app = this.getAppObject(context);
            if (device != null && device.length() > 0) {
                postData.put("app", (Object)app);
            }
            if ((user = this.getUserObject(context)) != null && user.length() > 0) {
                postData.put("user", (Object)user);
            }
            if ((regs = this.getRegsObject(context)) != null && regs.length() > 0) {
                postData.put("regs", (Object)regs);
            }
            if ((ext = this.getRequestExtData()) != null && ext.length() > 0) {
                postData.put("ext", (Object)ext);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return postData;
    }

    private JSONObject getRequestExtData() {
        JSONObject ext = new JSONObject();
        JSONObject prebid = new JSONObject();
        try {
            if (!Prebid.useLocalCache()) {
                JSONObject bids = new JSONObject();
                JSONObject cache = new JSONObject();
                cache.put("bids", (Object)bids);
                prebid.put("cache", (Object)cache);
            }
            JSONObject storedRequest = new JSONObject();
            storedRequest.put("id", (Object)Prebid.getAccountId());
            prebid.put("storedrequest", (Object)storedRequest);
            ext.put("prebid", (Object)prebid);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return ext;
    }

    private JSONArray getImps(ArrayList<AdUnit> adUnits) {
        JSONArray impConfigs = new JSONArray();
        for (AdUnit adUnit : adUnits) {
            try {
                JSONObject imp = new JSONObject();
                JSONObject ext = new JSONObject();
                imp.put("id", (Object)adUnit.getCode());
                if (Prebid.isSecureConnection()) {
                    imp.put("secure", 1);
                }
                if (adUnit.getAdType().equals((Object)AdType.INTERSTITIAL)) {
                    imp.put("instl", 1);
                }
                imp.put("ext", (Object)ext);
                JSONObject prebid = new JSONObject();
                ext.put("prebid", (Object)prebid);
                JSONObject storedrequest = new JSONObject();
                prebid.put("storedrequest", (Object)storedrequest);
                storedrequest.put("id", (Object)adUnit.getConfigId());
                imp.put("ext", (Object)ext);
                JSONObject banner = new JSONObject();
                JSONArray format = new JSONArray();
                for (AdSize size : adUnit.getSizes()) {
                    format.put((Object)new JSONObject().put("w", size.getWidth()).put("h", size.getHeight()));
                }
                banner.put("format", (Object)format);
                imp.put("banner", (Object)banner);
                impConfigs.put((Object)imp);
            }
            catch (JSONException jSONException) {}
        }
        return impConfigs;
    }

    private JSONObject getDeviceObject(Context context) {
        JSONObject device = new JSONObject();
        try {
            Integer locDataAge;
            Integer locDataPrecision;
            Double lon;
            Double lat;
            if (!TextUtils.isEmpty((CharSequence)Settings.deviceMake)) {
                device.put("make", (Object)Settings.deviceMake);
            }
            if (!TextUtils.isEmpty((CharSequence)Settings.deviceModel)) {
                device.put("model", (Object)Settings.deviceModel);
            }
            if (!TextUtils.isEmpty((CharSequence)Settings.userAgent)) {
                device.put("ua", (Object)Settings.userAgent);
            }
            if (context != null) {
                NetworkInfo wifi;
                String networkOperator;
                device.put("w", context.getResources().getConfiguration().screenWidthDp);
                device.put("h", context.getResources().getConfiguration().screenHeightDp);
                device.put("pxratio", (double)context.getResources().getDisplayMetrics().density);
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (!(Settings.getMCC() >= 0 && Settings.getMNC() >= 0 || TextUtils.isEmpty((CharSequence)(networkOperator = telephonyManager.getNetworkOperator())))) {
                    try {
                        Settings.setMCC(Integer.parseInt(networkOperator.substring(0, 3)));
                        Settings.setMNC(Integer.parseInt(networkOperator.substring(3)));
                    }
                    catch (Exception e) {
                        Settings.setMCC(-1);
                        Settings.setMNC(-1);
                    }
                }
                if (Settings.getMCC() > 0 && Settings.getMNC() > 0) {
                    device.put("mccmnc", (Object)String.format(Locale.ENGLISH, "%d-%d", Settings.getMCC(), Settings.getMNC()));
                }
                if (Settings.getCarrierName() == null) {
                    try {
                        Settings.setCarrierName(telephonyManager.getNetworkOperatorName());
                    }
                    catch (SecurityException ex) {
                        Settings.setCarrierName("");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)Settings.getCarrierName())) {
                    device.put("carrier", (Object)Settings.getCarrierName());
                }
                int connection_type = 0;
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                if (activeNetwork != null && activeNetwork.isConnected() && (wifi = cm.getNetworkInfo(1)) != null) {
                    connection_type = wifi.isConnected() ? 1 : 2;
                }
                device.put("connectiontype", connection_type);
            }
            Location lastLocation = null;
            Location appLocation = TargetingParams.getLocation();
            if (TargetingParams.getLocationEnabled()) {
                if (appLocation != null) {
                    lastLocation = appLocation;
                } else if (context != null && (context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0 || context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0)) {
                    LocationManager lm = (LocationManager)context.getSystemService("location");
                    for (String provider_name : lm.getProviders(true)) {
                        Location l = lm.getLastKnownLocation(provider_name);
                        if (l == null) continue;
                        if (lastLocation == null) {
                            lastLocation = l;
                            continue;
                        }
                        if (l.getTime() <= 0L || lastLocation.getTime() <= 0L || l.getTime() <= lastLocation.getTime()) continue;
                        lastLocation = l;
                    }
                } else {
                    LogUtil.w("PrebidServer", "Location permissions ACCESS_COARSE_LOCATION and/or ACCESS_FINE_LOCATION aren\\'t set in the host app. This may affect demand.");
                }
            }
            if (appLocation != lastLocation) {
                TargetingParams.setLocation(lastLocation);
            }
            if (lastLocation != null) {
                if (TargetingParams.getLocationDecimalDigits() <= -1) {
                    lat = lastLocation.getLatitude();
                    lon = lastLocation.getLongitude();
                } else {
                    lat = Double.parseDouble(String.format(Locale.ENGLISH, "%." + TargetingParams.getLocationDecimalDigits() + "f", lastLocation.getLatitude()));
                    lon = Double.parseDouble(String.format(Locale.ENGLISH, "%." + TargetingParams.getLocationDecimalDigits() + "f", lastLocation.getLongitude()));
                }
                locDataPrecision = Math.round(lastLocation.getAccuracy());
                locDataAge = (int)Math.max(0L, System.currentTimeMillis() - lastLocation.getTime());
            } else {
                lat = null;
                lon = null;
                locDataAge = null;
                locDataPrecision = null;
            }
            JSONObject geo = new JSONObject();
            if (lat != null && lon != null) {
                geo.put("lat", (Object)lat);
                geo.put("lon", (Object)lon);
                if (locDataAge != null) {
                    geo.put("lastfix", (Object)locDataAge);
                }
                if (locDataPrecision != null) {
                    geo.put("accuracy", (Object)locDataPrecision);
                }
            }
            if (geo.length() > 0) {
                device.put("geo", (Object)geo);
            }
            device.put("lmt", AdvertisingIDUtil.isLimitAdTracking() ? 1 : 0);
            if (!AdvertisingIDUtil.isLimitAdTracking() && !TextUtils.isEmpty((CharSequence)AdvertisingIDUtil.getAAID())) {
                device.put("ifa", (Object)AdvertisingIDUtil.getAAID());
            }
            device.put("os", (Object)"android");
            device.put("osv", (Object)String.valueOf(Build.VERSION.SDK_INT));
            if (!TextUtils.isEmpty((CharSequence)Settings.language)) {
                device.put("language", (Object)Settings.language);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return device;
    }

    private JSONObject getAppObject(Context context) {
        if (TextUtils.isEmpty((CharSequence)TargetingParams.getBundleName()) && context != null) {
            TargetingParams.setBundleName(context.getApplicationContext().getPackageName());
        }
        JSONObject app = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)TargetingParams.getBundleName())) {
                app.put("bundle", (Object)TargetingParams.getBundleName());
            }
            if (!TextUtils.isEmpty((CharSequence)Settings.pkgVersion)) {
                app.put("ver", (Object)Settings.pkgVersion);
            }
            if (!TextUtils.isEmpty((CharSequence)Settings.appName)) {
                app.put("name", (Object)Settings.appName);
            }
            if (!TextUtils.isEmpty((CharSequence)TargetingParams.getDomain())) {
                app.put("domain", (Object)TargetingParams.getDomain());
            }
            if (!TextUtils.isEmpty((CharSequence)TargetingParams.getStoreUrl())) {
                app.put("storeurl", (Object)TargetingParams.getStoreUrl());
            }
            app.put("privacypolicy", TargetingParams.getPrivacyPolicy());
            JSONObject publisher = new JSONObject();
            publisher.put("id", (Object)Prebid.getAccountId());
            app.put("publisher", (Object)publisher);
            JSONObject prebid = new JSONObject();
            prebid.put("source", (Object)"prebid-mobile");
            prebid.put("version", (Object)Settings.sdk_version);
            JSONObject ext = new JSONObject();
            ext.put("prebid", (Object)prebid);
            app.put("ext", (Object)ext);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return app;
    }

    private JSONObject getUserObject(Context context) {
        JSONObject user = new JSONObject();
        try {
            if (TargetingParams.getYearOfBirth() > 0) {
                user.put("yob", TargetingParams.getYearOfBirth());
            }
            TargetingParams.GENDER gender = TargetingParams.getGender();
            String g = "O";
            switch (gender) {
                case FEMALE: {
                    g = "F";
                    break;
                }
                case MALE: {
                    g = "M";
                    break;
                }
                case UNKNOWN: {
                    g = "O";
                }
            }
            user.put("gender", (Object)g);
            StringBuilder builder = new StringBuilder();
            ArrayList<String> keywords = TargetingParams.getUserKeywords();
            for (String key : keywords) {
                builder.append(key).append(",");
            }
            String finalKeywords = builder.toString();
            if (!TextUtils.isEmpty((CharSequence)finalKeywords)) {
                user.put("keywords", (Object)finalKeywords);
            }
            if (TargetingParams.isSubjectToGDPR(context) != null) {
                JSONObject ext = new JSONObject();
                ext.put("consent", (Object)TargetingParams.getGDPRConsentString(context));
                user.put("ext", (Object)ext);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return user;
    }

    private JSONObject getRegsObject(Context context) {
        JSONObject regs = new JSONObject();
        try {
            JSONObject ext = new JSONObject();
            if (TargetingParams.isSubjectToGDPR(context) != null) {
                if (TargetingParams.isSubjectToGDPR(context).booleanValue()) {
                    ext.put("gdpr", 1);
                } else {
                    ext.put("gdpr", 0);
                }
            }
            regs.put("ext", (Object)ext);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return regs;
    }
}

