/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import java.util.ArrayList;
import java.util.UUID;
import org.prebid.mobile.core.AdSize;
import org.prebid.mobile.core.AdType;

public abstract class AdUnit {
    protected String auctionId;
    protected String code;
    protected String configId;
    protected ArrayList<AdSize> sizes;
    private long timeToExpireAllBids = 0L;

    AdUnit(String code, String configId) {
        this.code = code;
        this.configId = configId;
        this.sizes = new ArrayList();
        this.generateNewAuctionId();
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getCode() {
        return this.code;
    }

    public String getAuctionId() {
        return this.auctionId;
    }

    public ArrayList<AdSize> getSizes() {
        return this.sizes;
    }

    public abstract AdType getAdType();

    void generateNewAuctionId() {
        this.auctionId = UUID.randomUUID().toString();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof AdUnit) {
            String otherAdSlotCode = ((AdUnit)o).getCode();
            String otherAdSlotConfig = ((AdUnit)o).getConfigId();
            if (this.getCode() != null && otherAdSlotCode != null) {
                return this.getCode().equalsIgnoreCase(otherAdSlotCode) && this.getConfigId().equalsIgnoreCase(otherAdSlotConfig);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.code == null || this.configId == null) {
            return super.hashCode();
        }
        return (this.code + this.configId).hashCode();
    }

    public String toString() {
        return "code: " + this.getCode() + " config: " + this.getConfigId() + " sizes: " + this.getSizesString();
    }

    private String getSizesString() {
        String output = "";
        for (AdSize size : this.sizes) {
            output = output.concat("Width: " + size.getWidth() + " Height: " + size.getHeight());
        }
        return output;
    }

    void setTimeThatShouldExpireAllBids(long millis) {
        if (millis > this.timeToExpireAllBids) {
            this.timeToExpireAllBids = millis;
        }
    }

    boolean shouldExpireAllBids(long currentTime) {
        return currentTime > this.timeToExpireAllBids;
    }
}

