/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.content.Context;
import android.os.Handler;
import android.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.prebid.mobile.core.AdUnit;
import org.prebid.mobile.core.BidResponse;
import org.prebid.mobile.core.DemandAdapter;
import org.prebid.mobile.core.ErrorCode;
import org.prebid.mobile.core.LogUtil;
import org.prebid.mobile.core.TargetingParams;

public class BidManager {
    private static final String TAG;
    private static Runnable expireBids;
    private static Handler handler;
    private static long periodToCheckExpiration;
    static DemandAdapter adapter;
    private static Set<AdUnit> adUnits;
    private static ConcurrentHashMap<String, ArrayList<BidResponse>> bidMap;
    static BidResponseListener bidResponseListener;

    static void registerAdUnit(AdUnit adUnit) {
        adUnits.add(adUnit);
    }

    static void setBidsExpirationRunnable(final Context context) {
        if (expireBids == null) {
            expireBids = new Runnable(){

                @Override
                public void run() {
                    if (bidMap != null && !bidMap.isEmpty() && context != null) {
                        long currentTime = System.currentTimeMillis();
                        for (String code : bidMap.keySet()) {
                            AdUnit adUnit = BidManager.getAdUnitByCode(code);
                            if (!adUnit.shouldExpireAllBids(currentTime)) continue;
                            BidManager.startNewAuction(context, adUnit);
                        }
                    }
                    handler.postDelayed(expireBids, periodToCheckExpiration);
                }
            };
            handler.postDelayed(expireBids, periodToCheckExpiration);
        }
    }

    static void requestBidsForAdUnits(Context context, ArrayList<AdUnit> adUnits) {
        TargetingParams.fetchLocationUpdates(context);
        if (adapter != null) {
            adapter.requestBid(context, bidResponseListener, adUnits);
        }
    }

    static void startNewAuction(Context context, AdUnit adUnit) {
        if (adUnit != null && adUnits.contains(adUnit)) {
            LogUtil.v(TAG, "New Auction run for AdUnit: " + adUnit.getCode());
            adUnit.generateNewAuctionId();
            bidMap.remove(adUnit.getCode());
            ArrayList<AdUnit> adUnits = new ArrayList<AdUnit>();
            adUnits.add(adUnit);
            BidManager.requestBidsForAdUnits(context, adUnits);
        }
    }

    private static boolean isBidReady(String adUnitCode) {
        return bidMap.keySet().contains(adUnitCode) && bidMap.get(adUnitCode) != null && !bidMap.get(adUnitCode).isEmpty();
    }

    static AdUnit getAdUnitByCode(String code) {
        for (AdUnit adUnit : adUnits) {
            if (adUnit.getCode() == null || !adUnit.getCode().equals(code)) continue;
            return adUnit;
        }
        return null;
    }

    static ArrayList<BidResponse> getWinningBids(String adUnitCode) {
        if (adUnitCode == null) {
            return null;
        }
        ArrayList<BidResponse> responses = bidMap.get(adUnitCode);
        if (responses != null && !responses.isEmpty()) {
            return responses;
        }
        return null;
    }

    protected static ArrayList<Pair<String, String>> getKeywordsForAdUnit(String adUnitCode, Context context) {
        AdUnit adUnit = BidManager.getAdUnitByCode(adUnitCode);
        if (adUnit == null) {
            LogUtil.e(TAG, String.format("AdUnit for code %s is not registered, no bid available.", adUnitCode));
            return null;
        }
        ArrayList<BidResponse> bidResponses = null;
        if (BidManager.isBidReady(adUnitCode)) {
            bidResponses = BidManager.getWinningBids(adUnitCode);
        }
        BidManager.startNewAuction(context, adUnit);
        if (bidResponses != null) {
            ArrayList<Pair<String, String>> keywordsPairs = new ArrayList<Pair<String, String>>();
            for (BidResponse bid : bidResponses) {
                for (Pair<String, String> keywords : bid.getCustomKeywords()) {
                    keywordsPairs.add(keywords);
                }
            }
            return keywordsPairs;
        }
        return null;
    }

    protected static void getKeywordsWhenReadyForAdUnit(final String adUnitCode, final int timeOut, final BidReadyListener listener) {
        if (listener != null) {
            final long startTime = System.currentTimeMillis();
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (BidManager.isBidReady(adUnitCode)) {
                        LogUtil.i(TAG, String.format(Locale.ENGLISH, "Top bid ready within %d ms", System.currentTimeMillis() - startTime));
                        listener.onBidReady(adUnitCode);
                    } else if (System.currentTimeMillis() - startTime >= (long)timeOut) {
                        LogUtil.i(TAG, String.format(Locale.ENGLISH, "Auction didn't complete within %d ms, trying to attach available top bid.", timeOut));
                        listener.onBidReady(adUnitCode);
                    } else {
                        handler.postDelayed((Runnable)this, 50L);
                    }
                }
            });
        }
    }

    protected static void reset() {
        if (adUnits != null) {
            adUnits.clear();
        }
        if (bidMap != null) {
            bidMap.clear();
        }
        if (expireBids != null) {
            handler.removeCallbacks(expireBids);
            expireBids = null;
        }
    }

    static void refreshBids(Context context) {
        if (bidMap != null) {
            bidMap.clear();
        }
        ArrayList<AdUnit> toBeRequested = new ArrayList<AdUnit>();
        if (adUnits != null) {
            for (AdUnit adUnit : adUnits) {
                toBeRequested.add(adUnit);
            }
        }
        BidManager.requestBidsForAdUnits(context, toBeRequested);
    }

    static void setPeriodToCheckExpiration(long period) {
        periodToCheckExpiration = period;
    }

    static ConcurrentHashMap<String, ArrayList<BidResponse>> getBidMap() {
        return bidMap;
    }

    static {
        handler = new Handler();
        periodToCheckExpiration = 30000L;
        TAG = LogUtil.getTagWithBase("BidManager");
        adUnits = new HashSet<AdUnit>();
        bidMap = new ConcurrentHashMap();
        bidResponseListener = new BidResponseListener(){

            @Override
            public void onBidSuccess(AdUnit adUnit, ArrayList<BidResponse> bidResponses) {
                LogUtil.i(TAG, "Bid Successful for adUnitId: " + adUnit.getCode());
                for (BidResponse bidResponse : bidResponses) {
                    adUnit.setTimeThatShouldExpireAllBids(System.currentTimeMillis() + bidResponse.getExpiryTime());
                }
                bidMap.remove(adUnit.getCode());
                bidMap.put(adUnit.getCode(), bidResponses);
            }

            @Override
            public void onBidFailure(AdUnit adUnit, ErrorCode reason) {
                LogUtil.e(TAG, "Request failed because of " + reason.toString().toLowerCase(Locale.getDefault()) + " for AdUnit code: " + adUnit.getCode());
            }
        };
    }

    protected static interface BidReadyListener {
        public void onBidReady(String var1);
    }

    public static interface BidResponseListener {
        public void onBidSuccess(AdUnit var1, ArrayList<BidResponse> var2);

        public void onBidFailure(AdUnit var1, ErrorCode var2);
    }
}

