/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.text.TextUtils;
import android.util.Log;

public class LogUtil {
    static final String BASE_TAG = "Prebid";

    private LogUtil() {
    }

    public static String getTagWithBase(String tagSuffix) {
        StringBuilder sb = new StringBuilder().append(BASE_TAG);
        if (!TextUtils.isEmpty((CharSequence)tagSuffix)) {
            sb.append("-").append(tagSuffix);
        }
        if (sb.length() > 23) {
            return sb.substring(0, 22);
        }
        return sb.toString();
    }

    public static void v(String message) {
        LogUtil.v(BASE_TAG, message);
    }

    public static void v(String tag, String message) {
        LogUtil.v(tag, message, null);
    }

    public static void v(String tag, String message, Throwable cause) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            if (Log.isLoggable((String)BASE_TAG, (int)2)) {
                Log.v((String)BASE_TAG, (String)message, (Throwable)cause);
            }
        } else if (Log.isLoggable((String)tag, (int)2)) {
            Log.v((String)tag, (String)message, (Throwable)cause);
        }
    }

    public static void d(String message) {
        LogUtil.d(BASE_TAG, message);
    }

    public static void d(String tag, String message) {
        LogUtil.d(tag, message, null);
    }

    public static void d(String tag, String message, Throwable cause) {
        try {
            if (Log.isLoggable((String)tag, (int)3)) {
                Log.d((String)tag, (String)message, (Throwable)cause);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)BASE_TAG, (String)("Tried to log a message with tag length >23: " + tag));
        }
        Log.d((String)BASE_TAG, (String)message, (Throwable)cause);
    }

    public static void i(String message) {
        LogUtil.i(BASE_TAG, message);
    }

    public static void i(String tag, String message) {
        LogUtil.i(tag, message, null);
    }

    public static void i(String tag, String message, Throwable cause) {
        try {
            if (Log.isLoggable((String)tag, (int)4)) {
                Log.i((String)tag, (String)message, (Throwable)cause);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)BASE_TAG, (String)("Tried to log a message with tag length >23: " + tag));
        }
        Log.i((String)BASE_TAG, (String)message, (Throwable)cause);
    }

    public static void w(String message) {
        LogUtil.w(BASE_TAG, message);
    }

    public static void w(String tag, String message) {
        LogUtil.w(tag, message, null);
    }

    public static void w(String tag, String message, Throwable cause) {
        try {
            if (Log.isLoggable((String)tag, (int)5)) {
                Log.w((String)tag, (String)message, (Throwable)cause);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)BASE_TAG, (String)("Tried to log a message with tag length >23: " + tag));
        }
        Log.w((String)BASE_TAG, (String)message, (Throwable)cause);
    }

    public static void e(String message) {
        LogUtil.e(BASE_TAG, message);
    }

    public static void e(String tag, String message) {
        LogUtil.e(tag, message, null);
    }

    public static void e(String tag, String message, Throwable cause) {
        try {
            if (Log.isLoggable((String)tag, (int)6)) {
                Log.e((String)tag, (String)message, (Throwable)cause);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)BASE_TAG, (String)("Tried to log a message with tag length >23: " + tag));
        }
        Log.e((String)BASE_TAG, (String)message, (Throwable)cause);
    }
}

