/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.core;

import android.text.TextUtils;
import android.util.Pair;
import java.util.ArrayList;

public class BidResponse {
    private static final long DEFAULT_EXPIRY = 300000L;
    private long expiryTime = 300000L;
    private Double cpm;
    private String creative;
    private String bidderCode;
    private long createdTime;
    private ArrayList<Pair<String, String>> customKeywords = new ArrayList();

    public BidResponse(Double cpm, String creative) {
        this.createdTime = System.currentTimeMillis();
        this.cpm = cpm;
        this.creative = creative;
    }

    public Double getCpm() {
        return this.cpm;
    }

    public String getCreative() {
        return this.creative;
    }

    public ArrayList<Pair<String, String>> getCustomKeywords() {
        return this.customKeywords;
    }

    public synchronized void addCustomKeyword(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        this.customKeywords.add((Pair<String, String>)new Pair((Object)key, (Object)value));
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createdTime >= this.expiryTime;
    }

    public void setBidderCode(String bidderCode) {
        this.bidderCode = bidderCode;
    }

    long getExpiryTime() {
        return this.expiryTime;
    }

    String getBidderCode() {
        return this.bidderCode;
    }

    public String toString() {
        return "Bidder name: " + this.getBidderCode() + " | BidResponse Price: " + this.getCpm();
    }
}

