/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile.prebidserver;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.core.LogUtil;
import org.prebid.mobile.prebidserver.internal.Settings;

class ServerConnector
extends AsyncTask<Object, Object, JSONObject> {
    private JSONObject postData;
    private WeakReference<ServerListener> listener;
    private String url;
    private Context context;

    ServerConnector(JSONObject postData, ServerListener listener, String url, Context context) {
        this.postData = postData;
        this.listener = new WeakReference<ServerListener>(listener);
        this.url = url;
        this.context = context;
    }

    protected JSONObject doInBackground(Object ... voids) {
        try {
            URL url = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            String existingCookie = this.getExistingCookie();
            if (existingCookie != null) {
                conn.setRequestProperty("Cookie", existingCookie);
            }
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(Settings.getConnectionTimeOutMillis());
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            wr.write(this.postData.toString());
            wr.flush();
            conn.connect();
            int httpResult = conn.getResponseCode();
            if (httpResult == 200) {
                String line;
                StringBuilder builder = new StringBuilder();
                InputStream is = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                is.close();
                String result = builder.toString();
                JSONObject response = new JSONObject(result);
                this.httpCookieSync(conn.getHeaderFields());
                return response;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onPostExecute(JSONObject jsonObject) {
        ServerListener listener = (ServerListener)this.listener.get();
        if (listener != null) {
            listener.onServerResponded(jsonObject);
        }
    }

    private void httpCookieSync(Map<String, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        CookieManager cm = CookieManager.getInstance();
        if (cm == null) {
            LogUtil.i("PrebidServer", "Unable to find a CookieManager");
            return;
        }
        try {
            String existingUUID = this.getExistingCookie();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                if (key == null || !key.equalsIgnoreCase("Set-cookie") && !key.equalsIgnoreCase("Set-cookie2")) continue;
                for (String cookieStr : entry.getValue()) {
                    if (TextUtils.isEmpty((CharSequence)cookieStr) || !cookieStr.contains("uuid2") || existingUUID != null && cookieStr.contains(existingUUID)) continue;
                    cm.setCookie("http://prebid.adnxs.com", cookieStr);
                    if (Build.VERSION.SDK_INT < 21) {
                        CookieSyncManager.createInstance((Context)this.context);
                        CookieSyncManager csm = CookieSyncManager.getInstance();
                        if (csm == null) {
                            LogUtil.i("PrebidServer", "Unable to find a CookieSyncManager");
                            return;
                        }
                        csm.sync();
                        continue;
                    }
                    cm.flush();
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getExistingCookie() {
        try {
            String wvcookie;
            CookieSyncManager.createInstance((Context)this.context);
            CookieManager cm = CookieManager.getInstance();
            if (cm != null && !TextUtils.isEmpty((CharSequence)(wvcookie = cm.getCookie("http://prebid.adnxs.com")))) {
                String[] existingCookies;
                for (String cookie : existingCookies = wvcookie.split("; ")) {
                    if (cookie == null || !cookie.contains("uuid2")) continue;
                    return cookie;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static interface ServerListener {
        public void onServerResponded(JSONObject var1);
    }
}

