/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.net.ConnectivityManager;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.prebid.mobile.BannerAdUnit;
import org.prebid.mobile.Host;
import org.prebid.mobile.InterstitialAdUnit;
import org.prebid.mobile.LogUtil;
import org.prebid.mobile.OnCompleteListener;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.ResultCode;
import org.prebid.mobile.TargetingParams;
import org.prebid.mobile.Util;
import org.prebid.mobile.a;
import org.prebid.mobile.b;
import org.prebid.mobile.d;
import org.prebid.mobile.l;

public abstract class AdUnit {
    private String a;
    private b b;
    private d c;
    private int d;
    private final Map e;
    private final Set f;

    AdUnit(String string, b b2) {
        this.a = string;
        this.b = b2;
        this.d = 0;
        this.e = new HashMap();
        this.f = new HashSet();
    }

    public void setAutoRefreshPeriodMillis(int n) {
        if (n < 30000) {
            LogUtil.w("periodMillis less then:30000");
            return;
        }
        this.d = n;
        if (this.c != null) {
            this.c.a(n);
        }
    }

    public void stopAutoRefresh() {
        LogUtil.v("Stopping auto refresh...");
        if (this.c != null) {
            this.c.b();
            this.c = null;
        }
    }

    public void fetchDemand(Object object, OnCompleteListener onCompleteListener) {
        Object object2;
        Object object32;
        if (TextUtils.isEmpty((CharSequence)PrebidMobile.getPrebidServerAccountId())) {
            LogUtil.e("Empty account id.");
            onCompleteListener.onComplete(ResultCode.INVALID_ACCOUNT_ID);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.a)) {
            LogUtil.e("Empty config id.");
            onCompleteListener.onComplete(ResultCode.INVALID_CONFIG_ID);
            return;
        }
        if (PrebidMobile.getPrebidServerHost().equals((Object)Host.CUSTOM) && TextUtils.isEmpty((CharSequence)PrebidMobile.getPrebidServerHost().getHostUrl())) {
            LogUtil.e("Empty host url for custom Prebid Server host.");
            onCompleteListener.onComplete(ResultCode.INVALID_HOST_URL);
            return;
        }
        HashSet hashSet = null;
        if (this.b == org.prebid.mobile.b.a) {
            hashSet = ((BannerAdUnit)this).a();
            for (Object object32 : hashSet) {
                if (((a)object32).a() >= 0 && ((a)object32).b() >= 0) continue;
                onCompleteListener.onComplete(ResultCode.INVALID_SIZE);
                return;
            }
        }
        Object object4 = null;
        if (this instanceof InterstitialAdUnit) {
            object32 = (InterstitialAdUnit)this;
            object4 = ((InterstitialAdUnit)object32).a();
        }
        if ((object32 = PrebidMobile.getApplicationContext()) != null) {
            object2 = (ConnectivityManager)object32.getSystemService("connectivity");
            if (!(object2 == null || object32.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0 || (object32 = object2.getActiveNetworkInfo()) != null && object32.isConnected())) {
                onCompleteListener.onComplete(ResultCode.NETWORK_ERROR);
                return;
            }
        } else {
            onCompleteListener.onComplete(ResultCode.INVALID_CONTEXT);
            return;
        }
        if (Util.a(object)) {
            this.c = new d(object);
            object2 = new l(this.a, this.b, hashSet, this.e, this.f, (a)object4);
            this.c.a(this.d);
            this.c.a((l)object2);
            this.c.a(onCompleteListener);
            if (this.d >= 30000) {
                LogUtil.v("Start fetching bids with auto refresh millis: " + this.d);
            } else {
                LogUtil.v("Start a single fetching.");
            }
            this.c.a();
            return;
        }
        onCompleteListener.onComplete(ResultCode.INVALID_AD_OBJECT);
    }

    public void addUserKeyword(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            TargetingParams.addUserKeyword(string2);
        }
    }

    public void addUserKeywords(String string, String[] stringArray) {
        if (stringArray.length > 0) {
            TargetingParams.addUserKeywords(new HashSet<String>(Arrays.asList(stringArray)));
        }
    }

    public void removeUserKeyword(String string) {
        TargetingParams.removeUserKeyword(string);
    }

    public void clearUserKeywords() {
        TargetingParams.clearUserKeywords();
    }

    public void addContextData(String string, String string2) {
        Util.a(this.e, (Object)string, (Object)string2);
    }

    public void updateContextData(String string, Set set) {
        this.e.put(string, set);
    }

    public void removeContextData(String string) {
        this.e.remove(string);
    }

    public void clearContextData() {
        this.e.clear();
    }

    public void addContextKeyword(String string) {
        this.f.add(string);
    }

    public void addContextKeywords(Set set) {
        this.f.addAll(set);
    }

    public void removeContextKeyword(String string) {
        this.f.remove(string);
    }

    public void clearContextKeywords() {
        this.f.clear();
    }
}

