/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetOptionCapabilities;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;

class NegotiateOptionsTask
implements Runnable,
TelnetConstants {
    private static final System.Logger logger = System.getLogger("telnet.lvl3");
    private TelnetSocket socket;
    private TelnetOutputStream out;
    private TelnetOptionCapabilities capabilities;

    public NegotiateOptionsTask(TelnetSocket socket) throws IOException {
        this.socket = socket;
        this.out = socket.out();
        this.capabilities = socket.getNegotiationResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.log(System.Logger.Level.WARNING, "ENTER: Detect supported TELNET options");
        try {
            this.out.write("Detecting Telnet capabilities\r\n".getBytes(StandardCharsets.US_ASCII));
            this.capabilities.capExchangeAwaitResponses.clear();
            for (Map.Entry<Integer, TelnetConstants.ControlCode> entry : this.socket.negotiate.entrySet()) {
                this.socket.lastStateSent.put(entry.getKey(), entry.getValue());
                this.capabilities.capExchangeAwaitResponses.add(entry.getKey());
                if (entry.getValue() == TelnetConstants.ControlCode.DO) {
                    this.out.sendDo(entry.getKey());
                    continue;
                }
                if (entry.getValue() == TelnetConstants.ControlCode.WILL) {
                    this.out.sendWill(entry.getKey());
                    continue;
                }
                if (entry.getValue() == TelnetConstants.ControlCode.WONT) {
                    this.out.sendWont(entry.getKey());
                    continue;
                }
                logger.log(System.Logger.Level.WARNING, "Ignore operation " + String.valueOf((Object)entry.getValue()) + " for " + String.valueOf(entry.getKey()));
            }
            this.socket.setState(TelnetSocket.State.OPTION_NEGOTIATION);
            logger.log(System.Logger.Level.INFO, "Initiated option negotiation for all options - waiting for results");
            Instant before = Instant.now();
            List<Integer> list = this.capabilities.capExchangeAwaitResponses;
            synchronized (list) {
                this.capabilities.capExchangeAwaitResponses.wait(500L);
            }
            Duration duration = Duration.between(before, Instant.now());
            logger.log(System.Logger.Level.DEBUG, "TELNET option negotiation required {0} ms\n", duration.toMillis());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error in Telnet capability exchange", (Throwable)e);
        }
        finally {
            logger.log(System.Logger.Level.WARNING, "LEAVE: Detect supported TELNET options\n");
        }
    }
}

