/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionCapabilities;
import org.prelle.telnet.TelnetOptionRegistry;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

class SubnegotiationTask
implements Runnable,
TelnetConstants {
    private static final System.Logger logger = System.getLogger("telnet.lvl3");
    private TelnetSocket socket;
    private TelnetOutputStream out;
    private TelnetOptionCapabilities capabilities;

    public SubnegotiationTask(TelnetSocket socket) throws IOException {
        this.socket = socket;
        this.out = socket.out();
        this.capabilities = socket.getNegotiationResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.log(System.Logger.Level.WARNING, "ENTER: TELNET subnegotiation");
        try {
            this.out.write("Telnet Negotiate\r\n".getBytes(StandardCharsets.US_ASCII));
            this.capabilities.capExchangeAwaitResponses.clear();
            logger.log(System.Logger.Level.DEBUG, "Subnegotiation starts for active options = {0}", this.socket.getActiveOptions());
            for (Integer n : this.socket.getActiveOptions()) {
                TelnetOption option = TelnetOption.valueOf(n);
                TelnetSubnegotiationHandler handler = TelnetOptionRegistry.get(n);
                if (handler != null) {
                    TelnetSubnegotiationHandler.logger.log(System.Logger.Level.INFO, "send subnegotiation for {0}", option.name());
                    boolean expectResult = handler.initializeAs(option, this.socket.getCommunicationRole(), this.socket, this.out);
                    if (!expectResult) continue;
                    this.capabilities.capSubNegAwaitResponses.add(n);
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "no subnegotiation for {0}", option.name());
            }
            this.socket.setState(TelnetSocket.State.OPTION_SUBNEGOTIATION);
            logger.log(System.Logger.Level.WARNING, "wait for all subnegs\n");
            Instant before = Instant.now();
            List<Integer> list = this.capabilities.capSubNegAwaitResponses;
            synchronized (list) {
                this.capabilities.capSubNegAwaitResponses.wait(500L);
            }
            Duration duration = Duration.between(before, Instant.now());
            logger.log(System.Logger.Level.WARNING, "TELNET subnegotiation required {0} ms\n", duration.toMillis());
            this.socket.setState(TelnetSocket.State.READY);
            logger.log(System.Logger.Level.WARNING, "After setting state to READY");
        }
        catch (SocketException e) {
            logger.log(System.Logger.Level.ERROR, "Error in Telnet capability exchange: " + String.valueOf(e));
            this.socket.setState(TelnetSocket.State.DISCONNECTED);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error in Telnet capability exchange", (Throwable)e);
        }
        finally {
            logger.log(System.Logger.Level.WARNING, "LEAVE: TELNET subnegotiation\n");
        }
    }
}

