/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

public interface TelnetConstants {
    public static final int EOR = 239;
    public static final int SE = 240;
    public static final int IP = 244;
    public static final int SB = 250;
    public static final int WILL = 251;
    public static final int WONT = 252;
    public static final int DO = 253;
    public static final int DONT = 254;
    public static final int IAC = 255;

    public static enum ControlCode {
        EOF(236),
        SUSP(237),
        ABORT(238),
        EOR(239),
        SE(240),
        NOP(241),
        DM(242),
        BREAK(243),
        IP(244),
        AE(245),
        AYT(246),
        EC(247),
        EL(248),
        GA(249),
        SB(250),
        WILL(251),
        WONT(252),
        DO(253),
        DONT(254),
        IAC(255);

        private final int codeValue;

        private ControlCode(int value) {
            this.codeValue = value;
        }

        public int code() {
            return this.codeValue;
        }

        public static ControlCode getCodeFor(int val) {
            for (ControlCode code : ControlCode.values()) {
                if (code.code() != val) continue;
                return code;
            }
            return null;
        }

        public static boolean isControlCode(int val) {
            for (ControlCode code : ControlCode.values()) {
                if (code.code() != val) continue;
                return true;
            }
            return false;
        }
    }
}

