/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetSocket;

public class TelnetServerSocket
extends ServerSocket {
    private static final System.Logger logger = System.getLogger("telnet.lvl3");
    private Map<Integer, TelnetConstants.ControlCode> negotiate = new LinkedHashMap<Integer, TelnetConstants.ControlCode>();

    public TelnetServerSocket(int port) throws IOException {
        super(port);
    }

    public TelnetServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public TelnetServerSocket support(int code, TelnetConstants.ControlCode willOrDo) {
        this.negotiate.put(code, willOrDo);
        return this;
    }

    @Override
    public Socket accept() throws IOException {
        TelnetSocket ret = new TelnetSocket();
        logger.log(System.Logger.Level.DEBUG, "Waiting for new connections");
        this.implAccept(ret);
        for (Map.Entry<Integer, TelnetConstants.ControlCode> entry : this.negotiate.entrySet()) {
            ret.support(entry.getKey(), entry.getValue());
        }
        logger.log(System.Logger.Level.DEBUG, "Incoming connection from {0},Port {1} - now initialize options", ret.getInetAddress().getHostAddress(), ret.getPort());
        ret.out().logger = System.getLogger("telnet.lvl1.out." + ret.getInetAddress().getHostAddress());
        ret.in().logger = System.getLogger("telnet.lvl1.in." + ret.getInetAddress().getHostAddress());
        logger.log(System.Logger.Level.DEBUG, "LEAVE accept()");
        return ret;
    }
}

