/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.NegotiateOptionsTask;
import org.prelle.telnet.SubnegotiationTask;
import org.prelle.telnet.TelnetCommand;
import org.prelle.telnet.TelnetConfigOption;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetInputStream;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionCapabilities;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOptionRegistry;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocketListener;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class TelnetSocket
extends Socket
implements TelnetConstants {
    private static final System.Logger logger = System.getLogger("telnet.lvl3");
    private static ExecutorService executor = Executors.newFixedThreadPool(1);
    private TelnetInputStream in;
    private TelnetOutputStream out;
    private CommunicationRole role;
    private State state = State.CREATED;
    private List<TelnetSocketListener> socketListener = new ArrayList<TelnetSocketListener>();
    Map<Integer, TelnetConstants.ControlCode> negotiate = new LinkedHashMap<Integer, TelnetConstants.ControlCode>();
    private Map<Integer, TelnetOptionListener> optionListener = new HashMap<Integer, TelnetOptionListener>();
    private TelnetOptionCapabilities optionCaps;
    private List<Integer> active = new ArrayList<Integer>();
    Map<Integer, TelnetConstants.ControlCode> lastStateSent = new HashMap<Integer, TelnetConstants.ControlCode>();

    public static ExecutorService getExecutorService() {
        return executor;
    }

    public TelnetSocket() {
        this.role = CommunicationRole.SERVER;
        this.optionCaps = new TelnetOptionCapabilities();
        this.optionCaps.capabilities.put(TelnetOption.ECHO, new TelnetConfigOption());
        this.optionCaps.capabilities.put(TelnetOption.EOR, new TelnetConfigOption());
        this.optionCaps.capabilities.put(TelnetOption.LINEMODE, new TelnetConfigOption());
    }

    public TelnetSocket(String host, int port) throws UnknownHostException, IOException {
        super(host, port);
        this.role = CommunicationRole.CLIENT;
        this.negotiate.put(0, TelnetConstants.ControlCode.DO);
        this.active.add(0);
        this.getOutputStream();
        this.getInputStream();
        this.out().logger = System.getLogger("telnet.lvl1.out." + host);
        this.in().logger = System.getLogger("telnet.lvl1.in." + host);
        this.optionCaps = new TelnetOptionCapabilities();
        this.optionCaps.capabilities.put(TelnetOption.ECHO, new TelnetConfigOption());
        this.optionCaps.capabilities.put(TelnetOption.EOR, new TelnetConfigOption());
        this.optionCaps.capabilities.put(TelnetOption.LINEMODE, new TelnetConfigOption());
    }

    public TelnetConfigOption getConfigOption(TelnetOption key) {
        return this.optionCaps.getConfigOption(key);
    }

    public Set<Map.Entry<TelnetOption, TelnetConfigOption>> getCapabilities() {
        return this.optionCaps.getCapabilities();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new TelnetInputStream(this, super.getInputStream());
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new TelnetOutputStream(super.getOutputStream());
        }
        return this.out;
    }

    public TelnetOutputStream out() throws IOException {
        return (TelnetOutputStream)this.getOutputStream();
    }

    TelnetInputStream in() throws IOException {
        return (TelnetInputStream)this.getInputStream();
    }

    public TelnetSocket support(int code, TelnetConstants.ControlCode willOrDo) {
        this.negotiate.put(code, willOrDo);
        return this;
    }

    public TelnetSocket support(int code, TelnetConstants.ControlCode willOrDo, Object configData) {
        this.optionCaps.setOptionData(code, configData);
        return this.support(code, willOrDo);
    }

    public TelnetSocket addSocketListener(TelnetSocketListener optList) {
        if (!this.socketListener.contains(optList)) {
            this.socketListener.add(optList);
        }
        return this;
    }

    void setState(State newState) {
        State oldState = this.state;
        this.state = newState;
        for (TelnetSocketListener callback : this.socketListener) {
            try {
                callback.telnetSocketChanged(this, oldState, newState);
            }
            catch (Throwable e) {
                logger.log(System.Logger.Level.ERROR, "Failed processing socket state change", e);
            }
        }
    }

    public TelnetSocket setOptionListener(int code, TelnetOptionListener callback) {
        logger.log(System.Logger.Level.WARNING, "Send events for option {0} to {1}", code, callback);
        if (callback == null) {
            throw new NullPointerException();
        }
        this.optionListener.put(code, callback);
        return this;
    }

    public TelnetSocket setOptionListener(TelnetOption option, TelnetOptionListener callback) {
        return this.setOptionListener(option.getCode(), callback);
    }

    public <E extends TelnetOptionListener> E getOptionListener(int code) {
        return (E)this.optionListener.get(code);
    }

    public <E> E getOptionData(int code) {
        return this.optionCaps.getOptionData(code);
    }

    public void setOptionData(int code, Object value) {
        this.optionCaps.setOptionData(code, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFeatureActive(TelnetOption option, boolean state) {
        logger.log(System.Logger.Level.DEBUG, "fireFeatureActive({0},{1})", new Object[]{option, state});
        if (this.state == State.OPTION_NEGOTIATION) {
            logger.log(System.Logger.Level.INFO, "Option {0} has been {1}", option.name(), state ? "ENABLED" : "REJECTED");
            TelnetConfigOption opt = this.optionCaps.getConfigOption(option);
            if (opt == null) {
                opt = new TelnetConfigOption();
                this.optionCaps.capabilities.put(option, opt);
            }
            opt.setConfigurable(state);
            opt.setActive(state);
        }
        if (state && !this.active.contains(option.getCode())) {
            this.active.add(option.getCode());
        }
        List<Integer> list = this.optionCaps.capExchangeAwaitResponses;
        synchronized (list) {
            if (this.optionCaps.capExchangeAwaitResponses.contains(option.getCode())) {
                this.optionCaps.capExchangeAwaitResponses.remove((Object)option.getCode());
                if (this.optionCaps.capExchangeAwaitResponses.isEmpty()) {
                    this.optionCaps.capExchangeAwaitResponses.notify();
                }
            }
        }
        for (TelnetSocketListener list2 : this.socketListener) {
            try {
                list2.telnetOptionStatusChange(this, option, state);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error calling " + String.valueOf(list2.getClass()) + ".telnetOptionStatusChange: " + String.valueOf(e), (Throwable)e);
            }
        }
    }

    public void fireTelnetCommand(TelnetCommand command) {
        for (TelnetSocketListener list : this.socketListener) {
            try {
                list.telnetCommandReceived(this, command);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error calling " + String.valueOf(list.getClass()) + ".telnetCommandReceived: " + String.valueOf(e), (Throwable)e);
            }
        }
    }

    public boolean isFeatureActive(int code) {
        return this.active.contains(code);
    }

    public boolean isFeatureSupported(TelnetOption option) {
        return this.getConfigOption(option) != null && this.getConfigOption(option).isConfigurable() != false;
    }

    void processCommand(TelnetCommand command) throws IOException {
        logger.log(System.Logger.Level.DEBUG, "RCV " + String.valueOf(command));
        switch (command.getCode()) {
            case DO: 
            case DONT: 
            case WILL: 
            case WONT: {
                break;
            }
            default: {
                logger.log(System.Logger.Level.WARNING, "fire " + String.valueOf(command));
                this.fireTelnetCommand(command);
                return;
            }
        }
        if (command.getData() == null) {
            logger.log(System.Logger.Level.ERROR, "Received {0} without an option code", new Object[]{command.getCode()});
            return;
        }
        int optionCode = command.getData();
        TelnetOption option = TelnetOption.valueOf(optionCode);
        TelnetSubnegotiationHandler handler = TelnetOptionRegistry.get(optionCode);
        TelnetConstants.ControlCode lastState = this.lastStateSent.getOrDefault(optionCode, TelnetConstants.ControlCode.WONT);
        TelnetConstants.ControlCode config = this.negotiate.get(optionCode);
        if (config != null) {
            switch (command.getCode()) {
                case DO: {
                    if (config == TelnetConstants.ControlCode.WILL) {
                        if (this.active.contains(optionCode)) {
                            return;
                        }
                        if (!this.active.contains(optionCode)) {
                            this.active.add(optionCode);
                        }
                        if (lastState == TelnetConstants.ControlCode.WILL) {
                            logger.log(System.Logger.Level.TRACE, "Don't respond to DO {0} , state would not change", option.name());
                        } else {
                            this.out.sendWill(optionCode);
                            logger.log(System.Logger.Level.WARNING, "Remote party sends DO {0} and we agreed with WILL {0}", option.name());
                        }
                        this.fireFeatureActive(option, true);
                        return;
                    }
                    if (config != TelnetConstants.ControlCode.DO) break;
                    logger.log(System.Logger.Level.WARNING, "Remote party sends DO {0} and we already sent DO {0}- answering with WILL", option.name());
                    this.out.sendWill(optionCode);
                    this.fireFeatureActive(option, true);
                    return;
                }
                case WILL: {
                    if (config != TelnetConstants.ControlCode.DO) break;
                    if (this.active.contains(optionCode)) {
                        return;
                    }
                    if (!this.active.contains(optionCode)) {
                        this.active.add(optionCode);
                    }
                    if (lastState == TelnetConstants.ControlCode.DO) {
                        logger.log(System.Logger.Level.DEBUG, "Don't respond to WILL {0} - state would not change", option.name());
                    } else {
                        this.out.sendDo(optionCode);
                        logger.log(System.Logger.Level.WARNING, "Remote party offers WILL {0} and we agreed with DO {0}", option.name());
                    }
                    this.fireFeatureActive(option, true);
                    return;
                }
                case DONT: 
                case WONT: {
                    for (int i = 0; i < this.active.size(); ++i) {
                        if (this.active.get(i) != optionCode) continue;
                        this.active.remove(i);
                        break;
                    }
                    this.fireFeatureActive(option, false);
                    return;
                }
            }
        } else {
            logger.log(System.Logger.Level.WARNING, "Remote party offered unsupported option {0}={1}", new Object[]{optionCode, option});
        }
        TelnetOptionListener listener = this.optionListener.get(optionCode);
        if (listener != null) {
            listener.remotePartySent(this, optionCode, command);
            return;
        }
        if (option == null) {
            logger.log(System.Logger.Level.WARNING, "Remote party requests {0} for unknown option {1} and we reject it", new Object[]{command.getCode(), command.getData()});
        } else {
            logger.log(System.Logger.Level.WARNING, "Remote party requests {0} for option {1} and we reject it = {2}", new Object[]{command.getCode(), option.name(), config});
        }
        this.reject(command);
    }

    private void reject(TelnetCommand command) throws IOException {
        switch (command.getCode()) {
            case DO: {
                this.out.sendWont(command.getData());
                break;
            }
            case WILL: {
                this.out.sendDont(command.getData());
            }
        }
    }

    public void processSubnegotiation(int code, int[] values) {
        logger.log(System.Logger.Level.TRACE, "RCV Subnegotiation for {0}: {1}", code, Arrays.toString(values));
        TelnetSubnegotiationHandler handler = TelnetOptionRegistry.get(code);
        if (handler == null) {
            logger.log(System.Logger.Level.WARNING, "Received {2} bytes subnegotiation for {0}/{1}, but cannot find a TelnetOptionHandler", new Object[]{code, TelnetOption.valueOf(code), values.length});
            return;
        }
        handler.handleSubnegotiation(code, values, this, this.out);
    }

    public CompletableFuture<TelnetOptionCapabilities> initialize() throws IOException {
        this.getOutputStream();
        this.getInputStream();
        this.setState(State.OPTION_NEGOTIATION);
        CompletionStage negotiation = ((CompletableFuture)CompletableFuture.runAsync(new NegotiateOptionsTask(this)).thenRunAsync(new SubnegotiationTask(this))).thenCompose(new Function<Void, CompletableFuture<TelnetOptionCapabilities>>(){

            @Override
            public CompletableFuture<TelnetOptionCapabilities> apply(Void arg0) {
                return CompletableFuture.completedFuture(TelnetSocket.this.optionCaps);
            }
        });
        return negotiation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subnegotiationEndedFor(int optionCode, Object data) {
        this.setOptionData(optionCode, data);
        logger.log(System.Logger.Level.INFO, "Negotiation for option {0}/{2} received {1}", new Object[]{optionCode, data, TelnetOption.valueOf(optionCode)});
        logger.log(System.Logger.Level.DEBUG, "expected are " + String.valueOf(this.optionCaps.capSubNegAwaitResponses));
        logger.log(System.Logger.Level.DEBUG, "status is " + String.valueOf((Object)this.state));
        if (this.state == State.OPTION_SUBNEGOTIATION) {
            List<Integer> list = this.optionCaps.capSubNegAwaitResponses;
            synchronized (list) {
                if (this.optionCaps.capSubNegAwaitResponses.contains(optionCode)) {
                    this.optionCaps.capSubNegAwaitResponses.remove((Object)optionCode);
                    if (this.optionCaps.capSubNegAwaitResponses.isEmpty()) {
                        logger.log(System.Logger.Level.WARNING, "DONE SUBNEG------------------------------");
                        this.optionCaps.capSubNegAwaitResponses.notify();
                    }
                }
            }
        }
    }

    public TelnetOptionCapabilities getNegotiationResult() {
        return this.optionCaps;
    }

    CommunicationRole getCommunicationRole() {
        return this.role;
    }

    public List<Integer> getActiveOptions() {
        return this.active;
    }

    public static enum State {
        CREATED,
        OPTION_NEGOTIATION,
        OPTION_SUBNEGOTIATION,
        READY,
        DISCONNECTED;

    }
}

