/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.mud;

import java.util.ArrayList;
import java.util.List;
import org.prelle.telnet.mud.MUDTerminalTypeStandard;
import org.prelle.telnet.option.TerminalType;

public class MUDTerminalTypeData
extends TerminalType.TerminalTypeData {
    private MUDTerminalTypeStandard.RequestState state;
    private String mudTerminalType;

    public MUDTerminalTypeData() {
        this.options = new ArrayList();
        this.options.add("-");
        this.options.add("-");
        this.options.add("MTTS 0");
    }

    public MUDTerminalTypeData(String ... values) {
        this.options = List.of(values);
        for (String tmp : values) {
            if (!tmp.startsWith("MTTS ")) continue;
            this.mudTerminalType = tmp;
        }
    }

    public MUDTerminalTypeData(List<String> values) {
        this.options = values;
        for (String tmp : values) {
            if (!tmp.startsWith("MTTS ")) continue;
            this.mudTerminalType = tmp;
        }
    }

    public String toString() {
        return String.format("Client: %s,  Terminal: %s, MTT: %s = %s", this.getClientName(), this.getTerminalType(), this.mudTerminalType, this.getCapabilities());
    }

    public String getClientName() {
        return (String)this.options.get(0);
    }

    public MUDTerminalTypeData setClientName(String clientName) {
        this.options.remove(0);
        this.options.add(0, clientName);
        return this;
    }

    public String getTerminalType() {
        return (String)this.options.get(1);
    }

    public MUDTerminalTypeData setTerminalType(String terminalType) {
        this.options.remove(1);
        this.options.add(1, terminalType);
        return this;
    }

    public MUDTerminalTypeStandard.RequestState getState() {
        return this.state;
    }

    public void setState(MUDTerminalTypeStandard.RequestState state) {
        this.state = state;
    }

    public String getMudTerminalType() {
        return this.mudTerminalType;
    }

    public void setMudTerminalType(String mudTerminalType) {
        this.mudTerminalType = mudTerminalType;
    }

    public List<Capability> getCapabilities() {
        if (this.mudTerminalType == null) {
            return List.of();
        }
        if (!this.mudTerminalType.startsWith("MTTS ")) {
            return List.of();
        }
        ArrayList<Capability> ret = new ArrayList<Capability>();
        try {
            int vector = Integer.parseInt(this.mudTerminalType.substring(5));
            return MUDTerminalTypeData.convertToList(vector);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public static List<Capability> convertToList(int vector) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        try {
            for (Capability cap : Capability.values()) {
                if ((vector & cap.getBit()) <= 0) continue;
                ret.add(cap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static enum Capability {
        ANSI(1),
        VT100(2),
        UTF8(4),
        COLOR256(8),
        MOUSE_TRACKING(16),
        OSC_COLOR_PALETTE(32),
        SCREEN_READER(64),
        PROXY(128),
        TRUECOLOR(256),
        MNES(512),
        MSLP(1024),
        SSL(2048);

        int bit;

        private Capability(int bit) {
            this.bit = bit;
        }

        public int getBit() {
            return this.bit;
        }
    }
}

