/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.option;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class TelnetEnvironmentOption
extends TelnetSubnegotiationHandler {
    protected static final System.Logger logger = System.getLogger("telnet.option.environ");
    public static final int CODE = 39;
    private static final int IS = 0;
    private static final int SEND = 1;
    private static final int INFO = 2;
    private static final int VAR = 0;
    private static final int VALUE = 1;
    private static final int ESC = 2;
    private static final int USERVAR = 3;

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.DEBUG, "performSubNegotiation for ENVIRON");
        int operation = values[0];
        switch (operation) {
            case 0: {
                this.handleIS(code, values, origin, out);
                break;
            }
            case 2: {
                this.handleINFO(code, values, origin, out);
                break;
            }
            default: {
                logger.log(System.Logger.Level.WARNING, "Other operations than IS not supported yet " + operation + "\n" + Arrays.toString(values));
            }
        }
    }

    private void handleIS(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        StringBuffer keyBuf = new StringBuffer();
        StringBuffer valBuf = new StringBuffer();
        Map variables = (Map)origin.getOptionData(39);
        int mode = -1;
        int i = 1;
        while (i < values.length) {
            int dat;
            if ((dat = values[i++]) == 255) {
                if (keyBuf.length() <= 0) break;
                logger.log(System.Logger.Level.INFO, "Variable {0}={1}", keyBuf, valBuf);
                variables.put(keyBuf.toString(), valBuf.toString());
                break;
            }
            switch (dat) {
                case 0: {
                    mode = dat;
                    if (keyBuf.length() > 0) {
                        logger.log(System.Logger.Level.DEBUG, "System Variable {0}={1}", keyBuf, valBuf);
                        variables.put(keyBuf.toString(), valBuf.toString());
                    }
                    keyBuf = new StringBuffer();
                    break;
                }
                case 3: {
                    mode = dat;
                    if (keyBuf.length() > 0) {
                        logger.log(System.Logger.Level.DEBUG, "User Variable {0}={1}", keyBuf, valBuf);
                        variables.put(keyBuf.toString(), valBuf.toString());
                    }
                    keyBuf = new StringBuffer();
                    break;
                }
                case 1: {
                    mode = dat;
                    valBuf = new StringBuffer();
                    break;
                }
                case 2: {
                    logger.log(System.Logger.Level.WARNING, "Not supported {0}", dat);
                    break;
                }
                default: {
                    if (mode == 0 || mode == 3) {
                        keyBuf.append((char)dat);
                        break;
                    }
                    if (mode != 1) break;
                    valBuf.append((char)dat);
                }
            }
            logger.log(System.Logger.Level.TRACE, "RCV {0} = {1}", dat, Character.valueOf((char)dat));
        }
        logger.log(System.Logger.Level.DEBUG, "Telnet Environment done: {0}", variables);
        origin.subnegotiationEndedFor(code, variables);
        try {
            EnvironmentListener listener = (EnvironmentListener)origin.getOptionListener(code);
            if (listener != null) {
                listener.telnetLearnedEnvironmentVariables(variables);
            } else {
                logger.log(System.Logger.Level.TRACE, "No EnvironmentListener");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleINFO(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.DEBUG, "handleINFO " + Arrays.toString(values));
        StringBuffer keyBuf = new StringBuffer();
        StringBuffer valBuf = new StringBuffer();
        Map variables = (Map)origin.getOptionData(39);
        int mode = -1;
        int i = 1;
        while (i < values.length) {
            int dat;
            if ((dat = values[i++]) == 255) {
                if (keyBuf.length() <= 0) break;
                logger.log(System.Logger.Level.INFO, "Variable {0}={1}", keyBuf, valBuf);
                variables.put(keyBuf.toString(), valBuf.toString());
                break;
            }
            switch (dat) {
                case 0: {
                    mode = dat;
                    if (keyBuf.length() > 0) {
                        logger.log(System.Logger.Level.DEBUG, "System Variable {0}={1}", keyBuf, valBuf);
                        variables.put(keyBuf.toString(), valBuf.toString());
                    }
                    keyBuf = new StringBuffer();
                    break;
                }
                case 3: {
                    mode = dat;
                    if (keyBuf.length() > 0) {
                        logger.log(System.Logger.Level.DEBUG, "User Variable {0}={1}", keyBuf, valBuf);
                        variables.put(keyBuf.toString(), valBuf.toString());
                    }
                    keyBuf = new StringBuffer();
                    break;
                }
                case 1: {
                    mode = dat;
                    valBuf = new StringBuffer();
                    break;
                }
                case 2: {
                    logger.log(System.Logger.Level.WARNING, "Not supported {0}", dat);
                    break;
                }
                default: {
                    if (mode == 0 || mode == 3) {
                        keyBuf.append((char)dat);
                        break;
                    }
                    if (mode != 1) break;
                    valBuf.append((char)dat);
                }
            }
            logger.log(System.Logger.Level.TRACE, "RCV {0} = {1}", dat, Character.valueOf((char)dat));
        }
        if (keyBuf.length() > 0) {
            logger.log(System.Logger.Level.DEBUG, "System Variable {0}={1}", keyBuf, valBuf);
            variables.put(keyBuf.toString(), valBuf.toString());
        }
        logger.log(System.Logger.Level.WARNING, "Telnet Environment done: {0}", variables);
        origin.subnegotiationEndedFor(code, variables);
        try {
            EnvironmentListener listener = (EnvironmentListener)origin.getOptionListener(code);
            if (listener != null) {
                listener.telnetLearnedEnvironmentVariables(variables);
            } else {
                logger.log(System.Logger.Level.TRACE, "No EnvironmentListener");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        if (role == CommunicationRole.SERVER) {
            logger.log(System.Logger.Level.DEBUG, "Ask remote party to send environment");
            try {
                origin.setOptionData(39, new HashMap());
                byte[] send = new byte[]{-1, -6, 39, 1, 0, 3, -1, -16};
                out.writeCommand(send);
                send = new byte[]{-1, -6, 39, 1, 0, -1, -16};
                out.writeCommand(send);
                send = new byte[]{-1, -6, 39, 1, 3, -1, -16};
                out.writeCommand(send);
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        logger.log(System.Logger.Level.WARNING, "Acting as PROVIDER not implemented");
        return false;
    }

    public static interface EnvironmentListener
    extends TelnetOptionListener {
        public void telnetLearnedEnvironmentVariables(Map<String, String> var1);
    }
}

