/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.option;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;
import org.prelle.telnet.mud.MUDTerminalTypeData;

public class TerminalType
extends TelnetSubnegotiationHandler {
    private static final int IS = 0;
    private static final int SEND = 1;
    private String[] answers;
    private Integer selected;

    public TerminalType(String ... options) {
        this.answers = options;
    }

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        try {
            if (role == CommunicationRole.SERVER) {
                logger.log(System.Logger.Level.DEBUG, "Ask remote party to send terminal types");
                ArrayList received = new ArrayList();
                origin.setOptionData(TelnetOption.TERMINAL_TYPE.getCode(), received);
                this.requestNext(out);
                return true;
            }
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "Failed requesting terminal type", (Throwable)e);
        }
        return false;
    }

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        int operation = values[0];
        if (operation == 1) {
            logger.log(System.Logger.Level.INFO, "Remote party requests terminal type information");
            try {
                this.sendNextFromList(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] data = new byte[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                data[i - 1] = (byte)values[i];
            }
            ArrayList<String> received = (ArrayList<String>)origin.getOptionData(TelnetOption.TERMINAL_TYPE.getCode());
            if (received == null) {
                received = new ArrayList<String>();
                origin.setOptionData(TelnetOption.TERMINAL_TYPE.getCode(), received);
            }
            String value = new String(data, StandardCharsets.US_ASCII);
            logger.log(System.Logger.Level.INFO, "TERMINAL_TYPE: Received {0}", value);
            if (!received.contains(value) && !"UNKNOWN".equals(value)) {
                received.add(value);
                try {
                    this.requestNext(out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Received {0}", received);
                origin.subnegotiationEndedFor(code, received);
                TerminalTypeListener listener = (TerminalTypeListener)origin.getOptionListener(code);
                logger.log(System.Logger.Level.INFO, "Listener {0}", listener);
                if (listener != null) {
                    if (received.size() == 3) {
                        listener.telnetTerminalTypesLearned(new MUDTerminalTypeData(received));
                    } else {
                        listener.telnetTerminalTypesLearned(new TerminalTypeData(received));
                    }
                } else {
                    logger.log(System.Logger.Level.TRACE, "No TerminalTypeListener");
                }
            }
        }
    }

    private void sendNextFromList(TelnetOutputStream out) throws IOException {
        String toSend;
        if (this.answers == null || this.answers.length == 0) {
            out.sendSubNegotiation(TelnetOption.TERMINAL_TYPE.getCode(), 0, "UNKNOWN".getBytes(StandardCharsets.ISO_8859_1));
            return;
        }
        if (this.selected == null) {
            this.selected = -1;
        }
        Integer n = this.selected;
        this.selected = this.selected + 1;
        String string = toSend = this.selected < this.answers.length ? this.answers[this.selected] : this.answers[this.answers.length - 1];
        if (this.selected >= this.answers.length) {
            this.selected = null;
        }
        logger.log(System.Logger.Level.INFO, "Send terminal type ''{0}''", toSend);
        out.sendSubNegotiation(TelnetOption.TERMINAL_TYPE.getCode(), 0, toSend.getBytes(StandardCharsets.ISO_8859_1));
    }

    private void requestNext(TelnetOutputStream out) throws IOException {
        byte[] send = new byte[]{-1, -6, (byte)TelnetOption.TERMINAL_TYPE.getCode(), 1, -1, -16};
        out.writeCommand(send);
        out.flush();
    }

    public static interface TerminalTypeListener
    extends TelnetOptionListener {
        public void telnetTerminalTypesLearned(TerminalTypeData var1);
    }

    public static class TerminalTypeData {
        protected List<String> options = new ArrayList<String>();

        public TerminalTypeData() {
            this.options = new ArrayList<String>();
        }

        public TerminalTypeData(String ... values) {
            this.options = List.of(values);
        }

        public TerminalTypeData(List<String> values) {
            this.options = values;
        }

        public void addOption(String value) {
            this.options.add(value);
        }

        public boolean hasOption(String value) {
            return this.options.contains(value);
        }

        public String getFirstOption() {
            return this.options.isEmpty() ? null : this.options.get(0);
        }

        public List<String> getAll() {
            return this.options;
        }
    }
}

