/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

public class LineBuffer {
    private static final System.Logger logger = System.getLogger("telnet");
    public static final int DELETE = 8;
    public static final int TABULATOR = 9;
    public static final int ENTER = 13;
    public static final int UP = 65;
    private StringBuffer input = new StringBuffer();
    private String lastInput;

    public void appendChar(char c) {
        this.input.append(c);
    }

    public void processKeyEvent(int key) {
        switch (key) {
            case 8: {
                if (this.input.length() > 0) {
                    this.input.deleteCharAt(this.input.length() - 1);
                }
                return;
            }
            case 13: {
                this.lastInput = this.input.toString();
                this.input = new StringBuffer();
                return;
            }
            case 65: {
                logger.log(System.Logger.Level.WARNING, "UICOmmon.LineBuffer.processKey: UP");
                return;
            }
        }
        logger.log(System.Logger.Level.WARNING, "TODO: LineBuffer.processKey: " + key);
    }

    public String getFinishedInput() {
        return this.lastInput;
    }

    public String getUnfinishedInput() {
        return this.input.toString();
    }

    public void setInput(String complete) {
        this.input.replace(0, this.input.length(), complete);
    }
}

