/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.prelle.telnet.TelnetCommand;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetSocket;

public class NewTelnetInputStream
extends FilterInputStream {
    System.Logger logger = System.getLogger("telnet.lvl1.in");
    private TelnetSocket listener;
    private boolean commandMode;
    private boolean dataIsSubnegotiation;
    boolean stickyCRLF = false;
    boolean seenCR = false;
    boolean sendGoAheadAsANSISepator = false;
    public boolean binaryMode = true;
    private List<Integer> subNegotiationBuffer = new ArrayList<Integer>();
    private int subNegotiationFor;
    private boolean characterMode;

    public NewTelnetInputStream(TelnetSocket list, InputStream in) {
        super(in);
        this.listener = list;
    }

    public void setBinaryMode(boolean enabled) {
        if (!this.binaryMode && enabled) {
            this.logger.log(System.Logger.Level.INFO, "Enable 8 bit binary transfer");
        } else if (this.binaryMode && !enabled) {
            this.logger.log(System.Logger.Level.WARNING, "Disable 8 bit binary transfer");
        }
        this.binaryMode = enabled;
    }

    public boolean isInBinaryMode() {
        return this.binaryMode;
    }

    private int tracingRead() throws IOException {
        int data = this.in.read();
        String name = data >= 240 ? TelnetConstants.ControlCode.getCodeFor(data).name() : "";
        this.logger.log(System.Logger.Level.TRACE, "RCV {0} {1} ", data, name);
        return data;
    }

    @Override
    public int read() throws IOException {
        if (this.commandMode) {
            int commandRaw = this.tracingRead();
            if (commandRaw == -1) {
                return -1;
            }
            TelnetConstants.ControlCode code = TelnetConstants.ControlCode.getCodeFor(commandRaw);
            if (code == null) {
                this.logger.log(System.Logger.Level.WARNING, "No Controlcode for " + commandRaw);
            }
            switch (code) {
                case IAC: {
                    return 255;
                }
                case WILL: 
                case WONT: 
                case DO: 
                case DONT: {
                    if (this.dataIsSubnegotiation) {
                        this.logger.log(System.Logger.Level.WARNING, "Receive an IAC {0} while in SB mode", new Object[]{code});
                    }
                    int cmdVal = this.tracingRead();
                    this.commandMode = false;
                    if (cmdVal == -1) {
                        this.logger.log(System.Logger.Level.WARNING, "Connection reset");
                        return -1;
                    }
                    this.logger.log(System.Logger.Level.INFO, "recv: {0} {1}", new Object[]{code, cmdVal});
                    this.listener.processCommand(new TelnetCommand(code, cmdVal));
                    break;
                }
                case SB: {
                    this.subNegotiationFor = this.tracingRead();
                    if (this.subNegotiationFor == -1) {
                        this.logger.log(System.Logger.Level.WARNING, "Connection reset");
                        this.commandMode = false;
                        this.logger.log(System.Logger.Level.TRACE, "Leaving command mode");
                        return -1;
                    }
                    TelnetOption option = TelnetOption.valueOf(this.subNegotiationFor);
                    this.logger.log(System.Logger.Level.DEBUG, "Subnegotiation begins for {0}/{1}", new Object[]{this.subNegotiationFor, option});
                    this.dataIsSubnegotiation = true;
                    this.commandMode = false;
                    this.logger.log(System.Logger.Level.TRACE, "Leaving command mode");
                    this.subNegotiationBuffer.clear();
                    break;
                }
                case SE: {
                    TelnetOption option = TelnetOption.valueOf(this.subNegotiationFor);
                    this.logger.log(System.Logger.Level.DEBUG, "Subnegotiation ends for {0}/{1}: {2}", new Object[]{this.subNegotiationFor, option, this.subNegotiationBuffer});
                    int[] values = new int[this.subNegotiationBuffer.size()];
                    int i = 0;
                    for (Integer v : this.subNegotiationBuffer) {
                        values[i++] = v;
                    }
                    this.listener.processSubnegotiation(this.subNegotiationFor, values);
                    this.subNegotiationBuffer.clear();
                    this.dataIsSubnegotiation = false;
                    break;
                }
                case GA: {
                    if (this.sendGoAheadAsANSISepator) {
                        this.commandMode = false;
                        this.logger.log(System.Logger.Level.DEBUG, "GA found - convert To ANSI RS (0x1E)");
                        this.logger.log(System.Logger.Level.DEBUG, "call listener " + String.valueOf(this.listener));
                        this.listener.processCommand(new TelnetCommand(code));
                        return 30;
                    }
                }
                default: {
                    this.commandMode = false;
                    this.logger.log(System.Logger.Level.TRACE, "Leaving command mode");
                    this.logger.log(System.Logger.Level.DEBUG, "call listener " + String.valueOf(this.listener));
                    this.listener.processCommand(new TelnetCommand(code));
                }
            }
        }
        if (this.dataIsSubnegotiation) {
            this.readInSubnegotiationMode();
        }
        this.commandMode = false;
        int data = -1;
        while (true) {
            data = this.in.read();
            this.logger.log(System.Logger.Level.TRACE, "RCV DATA {0} ({1})", data, Character.valueOf((char)data));
            if (data == -1) {
                return data;
            }
            if (data < 128 || this.binaryMode || data >= 255) break;
            this.logger.log(System.Logger.Level.WARNING, "Ignore character code {0} / {2} / {1} because not in binary mode", data, Character.valueOf((char)data), Integer.toHexString(data));
        }
        if (data == 255) {
            this.logger.log(System.Logger.Level.TRACE, "Entering command mode");
            this.commandMode = true;
            return this.read();
        }
        return data;
    }

    private int readInSubnegotiationMode() throws IOException {
        while (true) {
            int data = -1;
            while (true) {
                if ((data = this.tracingRead()) == -1) {
                    return data;
                }
                if (data < 128 || this.binaryMode || data >= 255) break;
                this.logger.log(System.Logger.Level.WARNING, "Ignore character code {0} / {1} because not in binary mode", data, Character.valueOf((char)data));
            }
            if (data == 255) {
                data = this.tracingRead();
                if (data == TelnetConstants.ControlCode.SE.code()) {
                    this.dataIsSubnegotiation = false;
                    int[] values = new int[this.subNegotiationBuffer.size()];
                    int i = 0;
                    for (Integer t : this.subNegotiationBuffer) {
                        values[i++] = t;
                    }
                    this.listener.processSubnegotiation(this.subNegotiationFor, values);
                    return data;
                }
                if (data < 255) {
                    this.logger.log(System.Logger.Level.WARNING, "Received a control code !=SE {0} while in sub-negotiation", data);
                }
            }
            this.subNegotiationBuffer.add(data);
        }
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int length) throws IOException {
        int c;
        if (this.binaryMode) {
            return super.read(bytes, off, length);
        }
        int offStart = off;
        while (--length >= 0 && (c = this.read()) != -1 && c != 10) {
            bytes[off++] = (byte)c;
        }
        return off > offStart ? off - offStart : -1;
    }

    @Override
    public long skip(long amount) throws IOException {
        return this.in.skip(amount);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public String readUntilCR() throws IOException {
        StringBuffer buf = new StringBuffer();
        int data = -1;
        do {
            data = this.read();
            switch (data) {
                case -1: {
                    return null;
                }
            }
            buf.append((char)data);
        } while (data > 31);
        return buf.toString();
    }

    public boolean isCharacterMode() {
        return this.characterMode;
    }

    public void setCharacterMode(boolean characterMode) {
        this.characterMode = characterMode;
    }

    public boolean isSendGoAheadAsANSISepator() {
        return this.sendGoAheadAsANSISepator;
    }

    public void setSendGoAheadAsANSISepator(boolean sendGoAheadAsANSISepator) {
        this.sendGoAheadAsANSISepator = sendGoAheadAsANSISepator;
    }
}

