/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetOption;

public class TelnetOutputStream
extends OutputStream {
    System.Logger logger = System.getLogger("telnet.lvl1.out");
    private OutputStream realOut;
    private boolean binaryMode = true;
    private boolean injectCRBeforeLF = true;

    public TelnetOutputStream(OutputStream out) {
        this.realOut = out;
    }

    public void setBinaryMode(boolean enabled) {
        this.binaryMode = enabled;
    }

    public boolean isInBinaryMode() {
        return this.binaryMode;
    }

    @Override
    public void write(int data) throws IOException {
        this.realOut.write(data);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.logger.log(System.Logger.Level.TRACE, "write " + new String(data));
        int count = 0;
        boolean lastWasCR = false;
        for (byte b : data) {
            if (b == -1) {
                ++count;
            }
            if (this.injectCRBeforeLF && b == 10 && !lastWasCR) {
                ++count;
            }
            lastWasCR = b == 13;
        }
        if (count > 0) {
            this.logger.log(System.Logger.Level.WARNING, "TODO: Encode 0xff");
            byte[] corrected = new byte[data.length + count];
            int pos = 0;
            lastWasCR = false;
            for (byte b : data) {
                if (b == -1) {
                    corrected[pos++] = -1;
                } else if (b == 10 && !lastWasCR) {
                    corrected[pos++] = 13;
                }
                corrected[pos++] = b;
                lastWasCR = b == 13;
            }
            data = corrected;
        }
        this.realOut.write(data);
    }

    public void writeCommand(byte[] data) throws IOException {
        this.realOut.write(data);
    }

    public void sendDo(int optionCode) throws IOException {
        byte[] data = new byte[]{(byte)TelnetConstants.ControlCode.IAC.code(), (byte)TelnetConstants.ControlCode.DO.code(), (byte)optionCode};
        this.logger.log(System.Logger.Level.INFO, "send: IAC DO {0}={1}", new Object[]{optionCode, TelnetOption.valueOf(optionCode)});
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendWill(int optionCode) throws IOException {
        byte[] data = new byte[]{(byte)TelnetConstants.ControlCode.IAC.code(), (byte)TelnetConstants.ControlCode.WILL.code(), (byte)optionCode};
        this.logger.log(System.Logger.Level.INFO, "send: IAC WILL {0}={1}", new Object[]{optionCode, TelnetOption.valueOf(optionCode)});
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendDont(int optionCode) throws IOException {
        byte[] data = new byte[]{(byte)TelnetConstants.ControlCode.IAC.code(), (byte)TelnetConstants.ControlCode.DONT.code(), (byte)optionCode};
        this.logger.log(System.Logger.Level.INFO, "send: IAC DONT {0}={1}", new Object[]{optionCode, TelnetOption.valueOf(optionCode)});
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendWont(int optionCode) throws IOException {
        byte[] data = new byte[]{(byte)TelnetConstants.ControlCode.IAC.code(), (byte)TelnetConstants.ControlCode.WONT.code(), (byte)optionCode};
        this.logger.log(System.Logger.Level.INFO, "send: IAC WONT {0}={1}", new Object[]{optionCode, TelnetOption.valueOf(optionCode)});
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendIAC(int optionCode) throws IOException {
        byte[] data = new byte[]{(byte)TelnetConstants.ControlCode.IAC.code(), (byte)optionCode};
        this.logger.log(System.Logger.Level.INFO, "send: IAC {0}={1}", new Object[]{optionCode, TelnetConstants.ControlCode.getCodeFor(optionCode)});
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendSubNegotiation(int code, int command, byte[] value) throws IOException {
        this.logger.log(System.Logger.Level.DEBUG, "sub-negotiation for {0}, command {1}, value={2}", code, command, value);
        byte[] data = new byte[6 + value.length];
        data[0] = (byte)TelnetConstants.ControlCode.IAC.code();
        data[1] = (byte)TelnetConstants.ControlCode.SB.code();
        data[2] = (byte)code;
        data[3] = (byte)command;
        System.arraycopy(value, 0, data, 4, value.length);
        data[data.length - 2] = (byte)TelnetConstants.ControlCode.IAC.code();
        data[data.length - 1] = (byte)TelnetConstants.ControlCode.SE.code();
        this.logger.log(System.Logger.Level.WARNING, "sub-negotiation for {0}, value={1}", code, Arrays.toString(data));
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendSubNegotiation(int code, byte[] value) throws IOException {
        this.logger.log(System.Logger.Level.INFO, "SND sub-negotiation for {0}, value={1}", code, Arrays.toString(value));
        byte[] data = new byte[5 + value.length];
        data[0] = (byte)TelnetConstants.ControlCode.IAC.code();
        data[1] = (byte)TelnetConstants.ControlCode.SB.code();
        data[2] = (byte)code;
        System.arraycopy(value, 0, data, 3, value.length);
        data[data.length - 2] = (byte)TelnetConstants.ControlCode.IAC.code();
        data[data.length - 1] = (byte)TelnetConstants.ControlCode.SE.code();
        this.logger.log(System.Logger.Level.INFO, "SND --> {0}", Arrays.toString(data));
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void sendSubNegotiation(int code, String line) throws IOException {
        this.logger.log(System.Logger.Level.INFO, "SND sub-negotiation for {0}: {1}", code, line);
        byte[] value = line.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[5 + value.length];
        data[0] = (byte)TelnetConstants.ControlCode.IAC.code();
        data[1] = (byte)TelnetConstants.ControlCode.SB.code();
        data[2] = (byte)code;
        System.arraycopy(value, 0, data, 3, value.length);
        data[data.length - 2] = (byte)TelnetConstants.ControlCode.IAC.code();
        data[data.length - 1] = (byte)TelnetConstants.ControlCode.SE.code();
        this.realOut.write(data);
        this.realOut.flush();
    }

    public void setInjectCRBeforeLF(boolean injectCRBeforeLF) {
        this.injectCRBeforeLF = injectCRBeforeLF;
    }
}

