/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.mud;

import java.util.Arrays;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class AardwolfMushclientProtocol
extends TelnetSubnegotiationHandler {
    private static final int CODE = 102;

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket nvt, TelnetOutputStream out) {
        AardwolfMushclientListener listener = (AardwolfMushclientListener)nvt.getOptionListener(102);
        switch (values[0]) {
            case 100: {
                MUDMode mode = MUDMode.valueOf(values[1]);
                logger.log(System.Logger.Level.DEBUG, "RCV: mode=" + String.valueOf((Object)mode));
                if (mode != null) {
                    if (listener != null) {
                        listener.telnetMudModeChanged(mode);
                    } else {
                        logger.log(System.Logger.Level.WARNING, "No AardwolfMushclientListener found as TelnetOptionListener");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Unknown mode {0} for Aardwolf protocol 102", values[1]);
                }
            }
            case 101: {
                logger.log(System.Logger.Level.DEBUG, "RCV: TICK");
                if (listener != null) {
                    listener.telnetTickReceived();
                    break;
                }
                logger.log(System.Logger.Level.WARNING, "No AardwolfMushclientListener found as TelnetOptionListener");
                break;
            }
            default: {
                logger.log(System.Logger.Level.WARNING, "TODO: we received2 : {0}", Arrays.toString(values));
            }
        }
    }

    public static interface AardwolfMushclientListener
    extends TelnetOptionListener {
        public void telnetMudModeChanged(MUDMode var1);

        public void telnetTickReceived();
    }

    public static enum MUDMode {
        LOGIN_SCREEN(1),
        START_SCREEN(2),
        FULL_ACTIVE(3),
        AFK(4),
        NOTE_MODE(5),
        BUILDING(6),
        PAGED_OUTPUT(7);

        int code;

        private MUDMode(int val) {
            this.code = val;
        }

        static MUDMode valueOf(int i) {
            for (MUDMode tmp : MUDMode.values()) {
                if (tmp.code != i) continue;
                return tmp;
            }
            return null;
        }
    }
}

