/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.mud;

import java.io.IOException;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class GenericMUDCommunicationProtocol
extends TelnetSubnegotiationHandler {
    protected static final System.Logger logger = System.getLogger("gmcp.raw");
    public static final int CODE = 201;

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.INFO, "No need for initialization for {0} / as {2}", new Object[]{option.name(), this.getClass().getName(), role});
        return false;
    }

    public static void send(TelnetOutputStream out, String packName, String command) throws IOException {
        String full = command != null ? packName + " " + command : packName;
        out.sendSubNegotiation(201, full);
    }

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        RawGMCPMessage msg = new RawGMCPMessage(values);
        Object listenerR = origin.getOptionListener(201);
        logger.log(System.Logger.Level.INFO, "RCV {0}", msg.getNamespace());
        GMCPReceiver listener = (GMCPReceiver)listenerR;
        if (listener != null) {
            listener.telnetReceiveGMCP(msg);
        } else {
            logger.log(System.Logger.Level.WARNING, "No listener for GMCP - use session.getSocket().setOptionListener(TelnetOption.GMCP, ...)");
        }
    }

    public static class RawGMCPMessage {
        private String namespace;
        private String msg;

        public RawGMCPMessage(int[] values) {
            StringBuffer ns = new StringBuffer();
            StringBuffer m = new StringBuffer();
            boolean isNamespace = true;
            for (int code : values) {
                if (isNamespace) {
                    if (code == 32) {
                        isNamespace = false;
                        continue;
                    }
                    ns.append((char)code);
                    continue;
                }
                m.append((char)code);
            }
            this.namespace = ns.toString().trim();
            this.msg = m.toString().trim();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return "GMCP:" + this.namespace + " " + this.msg;
        }
    }

    public static interface GMCPReceiver
    extends TelnetOptionListener {
        public void telnetReceiveGMCP(RawGMCPMessage var1);
    }
}

