/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.mud;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class MUDServerStatusProtocol
extends TelnetSubnegotiationHandler {
    protected static final System.Logger logger = System.getLogger("telnet.option.mssp");
    public static final int CODE = 70;
    private static final int MSSP_VAR = 1;
    private static final int MSSP_VAL = 2;
    private Supplier<Map<String, String>> dataSupplier;

    public MUDServerStatusProtocol(Supplier<Map<String, String>> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.ERROR, "Subnegotiate for MSSP: " + Arrays.toString(values));
        int operation = values[0];
        System.exit(1);
    }

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.ERROR, "TODO: initializeAs " + String.valueOf((Object)role));
        switch (role) {
            case SERVER: {
                Map<String, String> data = this.dataSupplier.get();
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    buf.append('\u0001');
                    buf.append(entry.getKey());
                    buf.append('\u0002');
                    buf.append(entry.getValue());
                }
                System.out.println("Send " + String.valueOf(buf));
                try {
                    out.sendSubNegotiation(70, buf.toString());
                    break;
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.WARNING, "Failed sending telnet option", (Throwable)e);
                }
            }
        }
        return false;
    }
}

