/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.option;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetConstants;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class LineMode
extends TelnetSubnegotiationHandler {
    private CommunicationRole role;

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        this.role = role;
        try {
            if (role == CommunicationRole.SERVER) {
                logger.log(System.Logger.Level.INFO, "Start character-a-time mode by clearing EDIT flag");
                LineMode.setFlags(out, List.of(ModeBit.TRAPSIG));
                return true;
            }
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "Failed requesting terminal type", (Throwable)e);
        }
        return false;
    }

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.DEBUG, "LineMode sub {0} as {1}", new Object[]{Arrays.toString(values), this.role});
        Operation op = null;
        if (values[0] >= 251) {
            TelnetConstants.ControlCode c0 = TelnetConstants.ControlCode.getCodeFor(values[0]);
            op = Operation.valueOf(values[1]);
            logger.log(System.Logger.Level.INFO, "IAC SB LINEMODE {0} {1}", new Object[]{c0, op});
            int[] remain = new int[values.length - 2];
            System.arraycopy(values, 2, remain, 0, remain.length);
            this.forwardMask(origin, out, c0, remain);
            return;
        }
        op = Operation.valueOf(values[0]);
        switch (op.ordinal()) {
            case 0: {
                int mask = values[1];
                List<ModeBit> modes = ModeBit.toModeList(mask);
                logger.log(System.Logger.Level.DEBUG, "IAC SB LINEMODE MODE " + String.valueOf(modes));
                if (this.role == CommunicationRole.SERVER && !modes.contains((Object)ModeBit.MODE_ACK)) {
                    logger.log(System.Logger.Level.WARNING, "Ignore, because we are server - noone tells us what to do");
                    return;
                }
                LineModeListener lmList = (LineModeListener)origin.getOptionListener(TelnetOption.LINEMODE.getCode());
                if (lmList != null) {
                    if (modes.contains((Object)ModeBit.MODE_ACK)) {
                        lmList.linemodeFlagsAcknowledged(modes);
                        break;
                    }
                    List<ModeBit> confirmed = lmList.linemodeFlagsSuggested(modes);
                    LineMode.confirmMode(out, confirmed);
                    break;
                }
                logger.log(System.Logger.Level.WARNING, "No LineModeListener configured");
                break;
            }
            case 2: {
                logger.log(System.Logger.Level.INFO, "IAC SB LINEMODE SLC {0}", Arrays.toString(values));
                int i = 1;
                while (i < values.length) {
                    int funct = values[i++];
                    int modif = values[i++];
                    int chara = values[i++];
                    SLCType type = SLCType.valueOf(funct);
                    SupportLevel level = SupportLevel.valueOf(modif & 7);
                    boolean ack = (modif & 0x80) > 0;
                    boolean flushIn = (modif & 0x40) > 0;
                    boolean flushOut = (modif & 0x20) > 0;
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add(level.name());
                    if (ack) {
                        tmp.add("ACK");
                    }
                    if (flushIn) {
                        tmp.add("FLUSH_IN");
                    }
                    if (flushOut) {
                        tmp.add("FLUSH_OUT");
                    }
                    switch (level.ordinal()) {
                        case 0: {
                            logger.log(System.Logger.Level.DEBUG, "Operation {0} is supported and should use default characters - {2}", new Object[]{type, Integer.toHexString(chara), tmp});
                            break;
                        }
                        case 1: {
                            logger.log(System.Logger.Level.DEBUG, "Operation {0} is supported and uses character 0x{1} - which can be changed - {2}", new Object[]{type, Integer.toHexString(chara), tmp});
                            break;
                        }
                        case 2: {
                            logger.log(System.Logger.Level.DEBUG, "Operation {0} is supported and uses character 0x{1} - this cannot be changed - {2}", new Object[]{type, Integer.toHexString(chara), tmp});
                            break;
                        }
                        case 3: {
                            logger.log(System.Logger.Level.DEBUG, "Operation {0} is not supported ", new Object[]{type});
                        }
                    }
                }
                break;
            }
            default: {
                logger.log(System.Logger.Level.INFO, "IAC SB LINEMODE " + String.valueOf((Object)op));
                logger.log(System.Logger.Level.WARNING, "Unhandled " + String.valueOf((Object)op));
            }
        }
    }

    private static void confirmMode(TelnetOutputStream out, List<ModeBit> confirmed) {
        int mask = ModeBit.MODE_ACK.value;
        for (ModeBit flag : confirmed) {
            mask |= flag.value;
        }
        byte[] values = new byte[]{(byte)Operation.MODE.value, (byte)mask};
        try {
            out.sendSubNegotiation(TelnetOption.LINEMODE.getCode(), values);
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.WARNING, "Error sending subnegotiation", (Throwable)e);
        }
    }

    private void forwardMask(TelnetSocket origin, TelnetOutputStream out, TelnetConstants.ControlCode c0, int[] values) {
        logger.log(System.Logger.Level.WARNING, "Forwardmask {0}: {1}", new Object[]{c0, Arrays.toString(values)});
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            for (int b = 0; b < 8; ++b) {
                int code = i * 8 + b + 1;
                int mask = 1 << 7 - b;
                if ((values[i] & mask) <= 0) continue;
                codes.add(code);
            }
        }
        LineModeListener lmList = (LineModeListener)origin.getOptionListener(TelnetOption.LINEMODE.getCode());
        if (lmList != null) {
            lmList.sendFlushOn(codes);
        }
    }

    public static void setFlags(TelnetOutputStream out, List<ModeBit> flags) throws IOException {
        int flagMask = 0;
        for (ModeBit flag : flags) {
            flagMask |= flag.value;
        }
        out.sendSubNegotiation(TelnetOption.LINEMODE.getCode(), new byte[]{(byte)Operation.MODE.value, (byte)flagMask});
    }

    public static enum ModeBit {
        EDIT(1),
        TRAPSIG(2),
        MODE_ACK(4),
        SOFT_TAB(8),
        LIT_ECHO(16);

        int value;

        private ModeBit(int value) {
            this.value = value;
        }

        public static ModeBit valueOf(int val) {
            for (ModeBit tmp : ModeBit.values()) {
                if (tmp.value != val) continue;
                return tmp;
            }
            return null;
        }

        public static List<ModeBit> toModeList(int val) {
            ArrayList<ModeBit> ret = new ArrayList<ModeBit>();
            for (ModeBit tmp : ModeBit.values()) {
                if ((val & tmp.value) <= 0) continue;
                ret.add(tmp);
            }
            return ret;
        }
    }

    static enum Operation {
        MODE(1),
        FORWARDMASK(2),
        SLC(3);

        int value;

        private Operation(int value) {
            this.value = value;
        }

        public static Operation valueOf(int val) {
            for (Operation tmp : Operation.values()) {
                if (tmp.value != val) continue;
                return tmp;
            }
            logger.log(System.Logger.Level.ERROR, "Unknown operation code {0}", val);
            return null;
        }
    }

    public static interface LineModeListener
    extends TelnetOptionListener {
        public List<ModeBit> linemodeFlagsSuggested(List<ModeBit> var1);

        public void linemodeFlagsAcknowledged(List<ModeBit> var1);

        public void sendFlushOn(List<Integer> var1);
    }

    static enum SLCType {
        SYNCH(1),
        BRK(2),
        IP(3),
        AO(4),
        AYT(5),
        EOR(6),
        ABORT(7),
        EOF(8),
        SUSP(9),
        EC(10),
        EL(11),
        EW(12),
        RP(13),
        LNEXT(14),
        XON(15),
        XOFF(16),
        FORW1(17),
        FORW2(18),
        MCL(19),
        MCR(20),
        MCWL(21),
        MCWR(22),
        MCBOL(23),
        MCEOL(24),
        INSRT(25),
        OVER(26),
        ECR(27),
        EWR(28),
        EBOL(29),
        EEOL(30);

        int value;

        private SLCType(int value) {
            this.value = value;
        }

        public static SLCType valueOf(int code) {
            for (SLCType func : SLCType.values()) {
                if (func.value != code) continue;
                return func;
            }
            throw new IllegalArgumentException("Not a SLCcode: " + code);
        }
    }

    static enum SupportLevel {
        DEFAULT(3),
        VALUE(2),
        CANTCHANGE(1),
        NOSUPPORT(0);

        int value;

        private SupportLevel(int value) {
            this.value = value;
        }

        public static SupportLevel valueOf(int val) {
            for (SupportLevel tmp : SupportLevel.values()) {
                if (tmp.value != val) continue;
                return tmp;
            }
            return null;
        }
    }

    public static class SendBufferedDataOn {
        private TelnetConstants.ControlCode request;
        private List<Integer> codes;

        public SendBufferedDataOn(TelnetConstants.ControlCode request, List<Integer> codes) {
            this.codes = codes;
            this.request = request;
        }

        public List<Integer> getCodes() {
            return this.codes;
        }
    }

    public static class LineModesChanged {
        private List<ModeBit> lineModes;

        public LineModesChanged(List<ModeBit> modes) {
            this.lineModes = modes;
        }

        public void setModes(List<ModeBit> modes) {
            this.lineModes = modes;
        }

        public List<ModeBit> getModes() {
            return this.lineModes;
        }
    }

    public static class LineModeConfig {
        LineModeListener listener;
        List<ModeBit> flags = new ArrayList<ModeBit>();
        List<Integer> flushCodes = new ArrayList<Integer>();

        public LineModeConfig(List<ModeBit> flags, List<Integer> flushCodes) {
            this.flags.addAll(flags);
            this.flushCodes.addAll(flushCodes);
        }

        public LineModeConfig() {
            this.flags.add(ModeBit.EDIT);
            this.flushCodes.add(10);
            this.flushCodes.add(13);
        }
    }
}

