/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.option;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class MXPOption
extends TelnetSubnegotiationHandler {
    protected static final System.Logger logger = System.getLogger("telnet.option.mxp");
    private List<String> supports;
    private String client;

    public MXPOption(String ... supports) {
        this.supports = List.of(supports);
    }

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        System.err.println("MXPOption.initializeAs " + String.valueOf((Object)role));
        try {
            if (role == CommunicationRole.SERVER) {
                logger.log(System.Logger.Level.ERROR, "Ask for support");
                String support = "\u001b[6z<SUPPORT>\u001b[7z";
                out.write(support.getBytes(StandardCharsets.US_ASCII));
                return true;
            }
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "Failed requesting terminal type", (Throwable)e);
        }
        return false;
    }

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.WARNING, "MXPOption.handleSubnegotiation: " + Arrays.toString(values));
    }

    public void processMXP(String input) {
        logger.log(System.Logger.Level.ERROR, "MXP:" + input);
    }

    public static interface MXPListener
    extends TelnetOptionListener {
        public void telnetMXPLearned(MXPFeatures var1);
    }

    public static class MXPFeatures {
    }
}

