/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.option;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class TelnetCharset
extends TelnetSubnegotiationHandler {
    protected static final System.Logger logger = System.getLogger("telnet.option.charset");
    public static final int CODE = 42;
    private static final int REQUEST = 1;
    private static final int ACCEPTED = 2;
    private static final int REJECTED = 3;
    private static final int TTABLE_IS = 4;
    private static final int TTABLE_REJECTED = 5;
    private static final int TTABLE_ACK = 6;
    private static final int TTABLE_NAK = 8;

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket origin, TelnetOutputStream out) {
        block14: {
            logger.log(System.Logger.Level.DEBUG, "Subnegotiate for CHARSET: " + Arrays.toString(values));
            int operation = values[0];
            if (operation == 2) {
                byte[] data = new byte[values.length - 1];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (byte)values[i + 1];
                }
                String csName2 = new String(data);
                Charset charset = null;
                charset = "ISO 8859-15".equals(csName2) ? StandardCharsets.ISO_8859_1 : ("ISO 8859-1".equals(csName2) ? StandardCharsets.ISO_8859_1 : ("UTF-8".equals(csName2) || "UTF8".equals(csName2) ? StandardCharsets.UTF_8 : Charset.forName(csName2)));
                origin.setOptionData(42, charset);
                try {
                    CharsetListener listener = (CharsetListener)origin.getOptionListener(code);
                    if (listener != null) {
                        listener.telnetCharsetNegotiated(charset);
                        break block14;
                    }
                    logger.log(System.Logger.Level.TRACE, "No CharsetListener");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (operation == 1) {
                byte[] data = new byte[values.length - 1];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (byte)values[i + 1];
                }
                String namesRaw = new String(data);
                ArrayList<String> csNames = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(namesRaw);
                while (tok.hasMoreTokens()) {
                    csNames.add(tok.nextToken());
                }
                logger.log(System.Logger.Level.WARNING, "Remote party requested " + String.valueOf(csNames));
                ArrayList requested = new ArrayList();
                csNames.forEach(csName -> {
                    try {
                        Charset charset = null;
                        charset = "ISO 8859-15".equals(csName) ? StandardCharsets.ISO_8859_1 : ("ISO 8859-1".equals(csName) ? StandardCharsets.ISO_8859_1 : ("UTF-8".equals(csName) || "UTF8".equals(csName) ? StandardCharsets.UTF_8 : Charset.forName(csName)));
                        requested.add(charset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                logger.log(System.Logger.Level.WARNING, "TODO: What do I do? " + String.valueOf(requested));
                Charset consoleCharset = (Charset)origin.getOptionData(42);
                if (requested.contains(consoleCharset)) {
                    byte[] append = consoleCharset.toString().getBytes(StandardCharsets.US_ASCII);
                    logger.log(System.Logger.Level.WARNING, "Accept " + String.valueOf(consoleCharset));
                    try {
                        out.sendSubNegotiation(42, 2, append);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (operation == 3) {
                logger.log(System.Logger.Level.WARNING, "The remote party rejected our charset suggestions");
                System.err.println("TelnetCharset: Remote party rejected charsets");
            }
        }
    }

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        logger.log(System.Logger.Level.WARNING, "TODO: initializeAs " + String.valueOf((Object)role));
        if (role == CommunicationRole.SERVER) {
            logger.log(System.Logger.Level.DEBUG, "Ask remote party to send environment");
            try {
                origin.setOptionData(42, new HashMap());
                byte[] charsetData = "UTF-8 CP437 ASCII".getBytes(StandardCharsets.US_ASCII);
                byte[] send = new byte[charsetData.length + 7];
                send[0] = -1;
                send[1] = -6;
                send[2] = 42;
                send[3] = 1;
                send[4] = 32;
                System.arraycopy(charsetData, 0, send, 5, charsetData.length);
                send[5 + charsetData.length] = -1;
                send[6 + charsetData.length] = -16;
                logger.log(System.Logger.Level.DEBUG, "SND {0}", Arrays.toString(send));
                out.writeCommand(send);
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        logger.log(System.Logger.Level.WARNING, "Acting as PROVIDER not implemented");
        return false;
    }

    public static interface CharsetListener
    extends TelnetOptionListener {
        public void telnetCharsetNegotiated(Charset var1);
    }
}

