/*
 * Decompiled with CFR 0.152.
 */
package org.prelle.telnet.option;

import java.io.IOException;
import org.prelle.telnet.CommunicationRole;
import org.prelle.telnet.TelnetOption;
import org.prelle.telnet.TelnetOptionListener;
import org.prelle.telnet.TelnetOutputStream;
import org.prelle.telnet.TelnetSocket;
import org.prelle.telnet.TelnetSubnegotiationHandler;

public class TelnetWindowSize
extends TelnetSubnegotiationHandler {
    public static final int CODE = 31;
    protected static final System.Logger logger = System.getLogger("telnet.option.naws");

    @Override
    public boolean initializeAs(TelnetOption option, CommunicationRole role, TelnetSocket origin, TelnetOutputStream out) {
        int[] size;
        if (role == CommunicationRole.CLIENT && (size = (int[])origin.getOptionData(31)) != null && size.length == 2) {
            try {
                TelnetWindowSize.sendUpdate(origin, size[0], size[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void handleSubnegotiation(int code, int[] values, TelnetSocket nvt, TelnetOutputStream out) {
        int x = values[0] * 256 + values[1];
        int y = values[2] * 256 + values[3];
        logger.log(System.Logger.Level.DEBUG, "Terminal size = " + x + "*" + y);
        nvt.subnegotiationEndedFor(code, new int[]{x, y});
        TelnetNAWSListener listener = (TelnetNAWSListener)nvt.getOptionListener(code);
        if (listener != null) {
            listener.telnetWindowSizeChanged(x, y);
        } else {
            logger.log(System.Logger.Level.TRACE, "No TelnetNAWSListener");
        }
    }

    public static void sendUpdate(TelnetSocket origin, int w, int h) throws IOException {
        logger.log(System.Logger.Level.INFO, "Send NAWS {0}x{1}", w, h);
        byte[] command = new byte[]{(byte)(w / 256), (byte)(w % 256), (byte)(h / 256), (byte)(h % 256)};
        origin.out().sendSubNegotiation(31, command);
    }

    public static interface TelnetNAWSListener
    extends TelnetOptionListener {
        public void telnetWindowSizeChanged(int var1, int var2);
    }
}

